package com.pcloud.book.group.service.impl;

import com.pcloud.book.group.biz.WeworkTeacherBiz;
import com.pcloud.book.group.dto.WxWorkTeacherDTO;
import com.pcloud.book.group.service.WxWorkTeacherService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.ResponseHandleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/wxWorkTeacherService")
public class WxWorkTeacherServiceImpl implements WxWorkTeacherService {

    @Autowired
    private WeworkTeacherBiz weworkTeacherBiz;

    @Override
    @PostMapping("/getWxWorkTeacherByIds")
    public ResponseEntity<ResponseDto<Map<Long, WxWorkTeacherDTO>>> getWxWorkTeacherByIds(@RequestBody List<Long> teacherIds) {
        return ResponseHandleUtil.toResponse(weworkTeacherBiz.getWxWorkTeacherByIds(teacherIds));
    }
}
