package com.pcloud.book.group.vo;

import java.util.List;

import javax.validation.constraints.NotNull;

import com.pcloud.book.group.entity.ResourcePageBookstore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName com.pcloud.book.group.vo.UpdateResourcePageVO
 * @Author zhuyajie
 * @Description H5资源页修改
 * @Date 2021/3/26 16:55
 * @Version 1.0
 **/
@Data
public class UpdateResourcePageVO {

    /**
     * rays码id
     */
    private Long bookGroupId;
    /**
     * 风格类型（1默认2艺术3插画）
     */
    private Integer style;
    /**
     * 是否显示图书信息
     */
    private Integer showBook;
    /**
     * 是否开启小睿流程
     */
    private Integer openRays;
    /**
     * 是否开启世间食记
     */
    private Integer openFood;
    /**
     * 创建人
     */
    private Long createUser;
    /**
     * 二维码id
     */
    private Long sceneId;

    @ApiModelProperty("栏目内容")
    private List<UpdateResourceColumnVO> columnVOS;

    /**
     * 自定义配置的图书封面
     */
    private String bookCover;

    /**
     * 背景图
     */
    private String backgroundImg;

    @ApiModelProperty("实体书购买")
    private List<ResourcePageBookstore> resourcePageBookstoreList;
    /**
     * 字体颜色
     */
    private String fontColor;
}
