package com.pcloud.book.group.vo;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcloud.book.group.entity.WeworkTeacher;
import com.pcloud.common.utils.ParamChecker;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 客服老师企业微信二维码信息
 *
 * @author guiq
 * @version 1.0
 * @since 2020年9月7日
 */
@ApiModel("客服老师企业微信二维码信息")
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class WeworkTeacherVO implements Serializable {


    @ApiModelProperty("id")
    private Long id;

    /**
     * 企业微信二维码
     */
    @ApiModelProperty("企业微信二维码")
    private String qrcode;

    /**
     * 真实姓名
     */
    @ApiModelProperty("真实姓名")
    private String realName;

    /**
     * 图文素材标题名称
     */
    @ApiModelProperty("图文素材标题名称")
    private String title;

    /**
     * 昵称
     */
    @ApiModelProperty("昵称")
    private String nickname;

    /**
     * 头像地址
     */
    @ApiModelProperty("头像地址")
    private String avatar;

    /**
     * 描述
     */
    @ApiModelProperty("描述")
    private String desc;

    /**
     * 开关状态
     */
    @ApiModelProperty("开关状态")
    private Integer isOpen;

    /**
     * 图文素材地址
     */
    @ApiModelProperty("图文素材地址")
    private String materialUrl;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("适用人群类型")
    private List<Integer> crowdTypeList;


    private static final long serialVersionUID = 3857636238754367824L;

    public void checkParam4Add() {
        ParamChecker.checkStringIsEmpty(this.qrcode, "企业微信二维码不能为空！");
        ParamChecker.checkStringIsEmpty(this.realName, "真实姓名不能为空！");
        ParamChecker.checkStringIsEmpty(this.title, "Title 不能为空！");
    }

    public void checkParam4Update() {
        ParamChecker.checkNumberIsNull(this.id, "主键ID不能为空！");
    }

    /**
     * 判断是否需要更新素材
     *
     * @param weworkTeacher entity
     * @return boolean
     */
    public boolean checkIsChanged(WeworkTeacher weworkTeacher) {
        if (Objects.isNull(weworkTeacher) || !this.id.equals(weworkTeacher.getId())) {
            return false;
        }

        if (this.qrcode != null && !StrUtil.equals(this.qrcode, weworkTeacher.getQrcode())) {
            return true;
        }

        if (this.title != null && !StrUtil.equals(this.title, weworkTeacher.getTitle())) {
            return true;
        }

        if (this.avatar != null && !StrUtil.equals(this.avatar, weworkTeacher.getAvatar())) {
            return true;
        }

        if (this.desc != null && !StrUtil.equals(this.desc, weworkTeacher.getDesc())) {
            return true;
        }

        return false;
    }
}
