package com.pcloud.book.keywords.dao;

import com.pcloud.book.group.entity.BookGroupApp;
import com.pcloud.book.keywords.dto.GuideDTO;
import com.pcloud.book.keywords.entity.BookGuide;
import com.pcloud.book.keywords.vo.GuideVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @author lily
 * @date 2019/4/23 15:53
 */
public interface BookGuideDao extends BaseDao<BookGuide> {
    
    /**
     * @Author:lili
     * @Desr:根据社群码获取引导语
     * @Date:2019/4/23 20:31
     */
    GuideVO getGuideByBookGroup(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:根据分类获取引导语
     * @Date:2019/4/23 20:37
     */
    GuideVO getGuideByClassify(Long classifyId);
    
    /**
     * @Author:lili
     * @Desr获取引导语基本信息
     * @Date:2019/5/5 11:35
     */
    GuideDTO getBaseInfo(Long classifyId, Long bookGroupId);

    /**
     * 查询所有应用作品引导语
     */
    List<BookGroupApp> getAllAppGuide();
}
