package com.pcloud.book.mq.topic;

import com.pcloud.book.group.biz.GroupQrcodeBiz;
import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.book.pcloudkeyword.biz.PcloudRobotBiz;
import com.pcloud.book.reading.biz.ReadingActivityBiz;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.wechatgroup.message.dto.AddWXGroupDTO;
import com.pcloud.wechatgroup.selfrobot.dto.RobotStatusDTO;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Component
@RabbitListener(queues = MQTopicConumer.ROBOT_REAL_STATUS)
public class RobotRealStatusListener {

    @Resource
    private PcloudRobotBiz pcloudRobotBiz;

    /**
     * 处理小号真实状态
     */
    @ParamLog(value = "处理小号真实状态", isAfterReturn = false)
    @RabbitHandler
    public void onMessage(RobotStatusDTO dto) throws BizException {
        try {
            pcloudRobotBiz.changeRobotRealStatus(dto.getWxId(), dto.getStatus());
        } catch (Exception e) {
            log.error("接收微信用户进群消息失败" + e.getMessage(), e);
        }
    }
}
