package com.pcloud.book.pcloudkeyword.dao.impl;

import com.pcloud.book.pcloudKeyword.dto.RobotClassifyDTO;
import com.pcloud.book.pcloudkeyword.dao.PcloudRobotClassifyDao;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotClassify;
import com.pcloud.book.pcloudkeyword.facade.response.PcloudRobotClassifyResponseVO;
import com.pcloud.book.pcloudkeyword.vo.ClassifyOpenStatusUpdateVO;
import com.pcloud.book.pcloudkeyword.vo.ClassifySeqNumUpdateVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class PcloudRobotClassifyDaoImpl extends BaseDaoImpl<PcloudRobotClassify> implements PcloudRobotClassifyDao {

    @Override
    public List<PcloudRobotClassifyResponseVO> listAllRobotClassify() {
        return this.getSqlSession().selectList("listAllRobotClassify");
    }

    @Override
    public void updateRobotClassifyKeywordClassify(Long id, Long keywordClassifyId) {
        Map<String,Object> map=new HashMap<>();
        map.put("id",id);
        map.put("keywordClassifyId",keywordClassifyId);
        getSessionTemplate().update(getStatement("updateRobotClassifyKeywordClassify"),map);
    }

    @Override
    public void updateWelcomeDuration(Long id, Integer welcomeDuration,Integer isOpenPushH5url) {
        Map<String,Object> map=new HashMap<>();
        map.put("id",id);
        map.put("welcomeDuration",welcomeDuration);
        map.put("isOpenPushH5url",isOpenPushH5url);
        getSessionTemplate().update(getStatement("updateWelcomeDuration"),map);
    }

    @Override
    public void updateSeqNum4RobotClassify(ClassifySeqNumUpdateVO vo) {
        getSessionTemplate().update(getStatement("updateSeqNum4RobotClassify"), vo);
    }

    @Override
    public void updateOpenStatus4RobotClassify(ClassifyOpenStatusUpdateVO vo) {
        getSessionTemplate().update(getStatement("updateOpenStatus4RobotClassify"), vo);
    }

    @Override
    public void updateMiniAppQr(Long id, String url) {
        Map<String,Object> map=new HashMap<>();
        map.put("id",id);
        map.put("url",url);
        this.getSessionTemplate().update(getStatement("updateMiniAppQr"), map);
    }

    @Override
    public RobotClassifyDTO getClassifyInfo(Long robotType) {
        return  this.getSessionTemplate().selectOne(getStatement("getClassifyInfo"), robotType);
    }

    @Override
    public List<Long> getOpenTempletIds() {
        return this.getSessionTemplate().selectList(getStatement("getOpenTempletIds"));
    }

    @Override
    public List<RobotClassifyDTO> getClassifyInfoBatch(List<Integer> classifyIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("classifyIds",classifyIds);
        return this.getSessionTemplate().selectList(getStatement("getClassifyInfoBatch"), map);
    }
}
