package com.pcloud.book.personalstage.dao;

import com.pcloud.book.personalstage.dto.PersonalStageJumpKeywordDto;
import com.pcloud.book.personalstage.entity.PersonalStageJumpKeyword;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

public interface PersonalStageJumpKeywordDao extends BaseDao<PersonalStageJumpKeyword> {
    /**
     * 获取阶段内一个重复关键词
     * @param keywords
     * @return
     */
    PersonalStageJumpKeyword getStageKeywordByKeywords(List<String> keywords, Long personalStageId);

    /**
     * 批量添加
     * @param personalStageJumpKeywords
     */
    void batchInsert(List<PersonalStageJumpKeyword> personalStageJumpKeywords);

    /**
     * 根据阶段跳转id删除
     * @param jumpId
     */
    void deleteByJumpId(Long jumpId);

    /**
     * 查询命中的关键字
     * @param personalStageId
     * @param content
     * @param jumpType
     * @return
     */
    PersonalStageJumpKeywordDto getByKeyword(Long personalStageId, String content, Integer jumpType);

    String getFirstKeywordByPersonalStageId(Long personalStageId);
}