package com.pcloud.book.personalstage.dao.impl;

import com.pcloud.book.personalstage.dao.PersonalStageJumpEmailDao;
import com.pcloud.book.personalstage.entity.PersonalStageJumpEmail;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

@Component("personalStageJumpEmail")
public class PersonalStageJumpEmailDaoImpl extends BaseDaoImpl<PersonalStageJumpEmail> implements PersonalStageJumpEmailDao {
    @Override
    public void batchInsert(List<PersonalStageJumpEmail> personalStageJumpEmails) {
        super.getSessionTemplate().insert(getStatement("batchInsert"), personalStageJumpEmails);
    }

    @Override
    public List<PersonalStageJumpEmail> getByJumpId(Long jumpId) {
        return super.getSqlSession().selectList(getStatement("getByJumpId"), jumpId);
    }

    @Override
    public void deleteByJumpId(Long jumpId) {
        super.getSqlSession().delete(getStatement("deleteByJumpId"), jumpId);
    }
}
