package com.pcloud.book.push.biz;

import com.pcloud.book.push.dto.*;
import com.pcloud.book.push.entity.MorningEveningNews;
import com.pcloud.book.push.entity.Push;
import com.pcloud.book.push.entity.PushGroup;
import com.pcloud.book.push.entity.PushItem;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/4/17 17:46
 **/
public interface PushBiz {

    /**
     * 创建群发
     * @param push
     */
    void createPush(Push push);

    /**
     * 发送群消息
     * @param pushId
     */
    void sendGroupMessage(Long pushId);

    /**
     * 更新群发
     * @param push
     */
    void updatePush(Push push);

    /**
     * 删除群发
     * @param pushId
     * @param partyId
     */
    void deletePush(Long pushId, Long partyId);

    /**
     * 批量新增群发关联
     * @param pushGroups
     * @param partyId
     */
    void createPushGroupBatch(List<PushGroup> pushGroups, Long partyId);

    /**
     * 批量删除群发关联
     * @param pushGroupIds
     * @param partyId
     */
    void deletePushGroupBatch(List<Long> pushGroupIds, Long partyId);

    /**
     * 新增群发消息项
     * @param pushItem
     */
    void createPushItem(PushItem pushItem);

    /**
     * 删除群发消息项
     * @param pushItemId
     * @param partyId
     */
    void deletePushItem(Long pushItemId, Long partyId);

    /**
     * 群发项排序
     * @param pushItemIds
     * @param partyId
     */
    void sortPushItems(List<Long> pushItemIds, Long partyId);

    /**
     * 分页获取群发记录
     * @param partyId
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<PushDTO> getTimingPushList(Long partyId, Integer currentPage, Integer numPerPage);

    /**
     * 更新群发状态为成功
     * @param pushGroupRecordId
     */
    void updatePushStateSuccess(Integer pushGroupRecordId);

    /**
     * 修改群发时间
     * @param push
     */
    void updatePushTime(Push push);

    /**
     * 获取群发关联集合
     * @param pushId
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<PushGroupDTO> getPushGroupList(Long pushId, Boolean isRecord, Integer currentPage, Integer numPerPage);

    /**
     * 获取群发记录集合
     * @param partyId
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<PushRecordDTO> getPushRecordList(Long partyId, Integer currentPage, Integer numPerPage);

    /**
     * 新增早晚报
     * @param morningEveningNews
     * @return
     */
    Long createMorningEveningNews(MorningEveningNews morningEveningNews);

    /**
     * 修改早晚报
     * @param morningEveningNews
     */
    void updateMorningEveningNews(MorningEveningNews morningEveningNews);

    /**
     * 获取早晚报
     * @param partyId
     * @return
     */
    MorningEveningNews getMorningEveningNews(Long partyId);

    /**
     * 发送早晚报
     */
    void sendMorningEveningNews(Long partyId);

    /**
     * 新增计划式群发
     */
    void createPushPlan(PushPlanDTO pushPlanDTO);

    /**
     * 修改计划式群发
     */
    void updatePushPlan(PushPlanDTO pushPlanDTO);

    /**
     * 获取计划式群发
     */
    PushPlanDTO getPushPlan(Long pushPlanId);

    /**
     * 删除计划式群发
     */
    void deletePushPlan(Long pushPlanId, Long partyId);

    /**
     * 获取计划式群发列表
     */
    PageBeanNew<PushPlanDTO> getPushPlanList(String keyword, String day, Integer weekDay, Integer currentPage, Integer numPerPage, Long partyId);

    /**
     * 获取计划日历
     */
    List<String> getPushPlanCalendar(Long partyId);
}
