package com.pcloud.book.push.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/4/17 15:41
 **/
@ApiModel("消息推送模型")
public class Push extends BaseEntity {

    @ApiModelProperty("发送类型（1:立即发送 2:单次发送 3:每天发送 4:每周发送）")
    private Integer pushType;

    @ApiModelProperty("发送时间")
    private String pushTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("开始时间")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("结束时间")
    private Date endTime;

    @ApiModelProperty("周几")
    private Integer weekDay;

    @ApiModelProperty("计划id")
    private Long pushPlanId;

    @ApiModelProperty("是否删除")
    private Boolean isDelete;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("更新人")
    private Long updateUser;

    @ApiModelProperty("推送群集合")
    private List<PushGroup> pushGroups;

    @ApiModelProperty("推送消息项集合")
    private List<PushItem> pushItems;

    public Integer getPushType() {
        return pushType;
    }

    public void setPushType(Integer pushType) {
        this.pushType = pushType;
    }

    public String getPushTime() {
        return pushTime;
    }

    public void setPushTime(String pushTime) {
        this.pushTime = pushTime;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getWeekDay() {
        return weekDay;
    }

    public void setWeekDay(Integer weekDay) {
        this.weekDay = weekDay;
    }

    public Long getPushPlanId() {
        return pushPlanId;
    }

    public void setPushPlanId(Long pushPlanId) {
        this.pushPlanId = pushPlanId;
    }

    public Boolean getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Boolean isDelete) {
        this.isDelete = isDelete;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    public List<PushGroup> getPushGroups() {
        return pushGroups;
    }

    public void setPushGroups(List<PushGroup> pushGroups) {
        this.pushGroups = pushGroups;
    }

    public List<PushItem> getPushItems() {
        return pushItems;
    }

    public void setPushItems(List<PushItem> pushItems) {
        this.pushItems = pushItems;
    }

    @Override
    public String toString() {
        return "Push{" +
                "pushType=" + pushType +
                ", pushTime='" + pushTime + '\'' +
                ", startTime=" + startTime +
                ", endTime=" + endTime +
                ", weekDay=" + weekDay +
                ", pushPlanId=" + pushPlanId +
                ", isDelete=" + isDelete +
                ", createUser=" + createUser +
                ", updateUser=" + updateUser +
                ", pushGroups=" + pushGroups +
                ", pushItems=" + pushItems +
                "} " + super.toString();
    }
}
