package com.pcloud.book.reading.dao.impl;

import com.pcloud.book.reading.dao.ReadingGroupRobotDao;
import com.pcloud.book.reading.entity.ReadingGroupRobot;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：群小号关联表
 * @作者：zhuyajie
 * @创建时间：13:43 2020/1/20
 * @版本：1.0
 */
@Component("readingGroupRobotDao")
public class ReadingGroupRobotDaoImpl extends BaseDaoImpl<ReadingGroupRobot> implements ReadingGroupRobotDao {

    @Override
    public void updateWxGroupByGroupId(String wxGroupId, Long groupId) {
        Map<String, Object> map = new HashMap<>();
        map.put("wxGroupId", wxGroupId);
        map.put("groupId", groupId);
        getSessionTemplate().update(getStatement("updateWxGroupByGroupId"), map);
    }

    @Override
    public void setMaster(String altId, Long groupId) {
        Map<String, Object> map = new HashMap<>();
        map.put("altId", altId);
        map.put("groupId", groupId);
        getSessionTemplate().update(getStatement("setMaster"), map);
    }

    @Override
    public String getMasterRobotByWxGroupId(String wxGroupId) {
        return getSessionTemplate().selectOne(getStatement("getMasterRobotByWxGroupId"), wxGroupId);
    }

    @Override
    public List<Long> getGroupIdsByCount(Integer count) {
        return getSessionTemplate().selectList(getStatement("getGroupIdsByCount"), count);
    }

    @Override
    public Boolean groupExist(Long groupId, List<String> altIds) {
        Map<String,Object> map = new HashMap<>();
        map.put("groupId",groupId);
        map.put("altIds",altIds);
        return getSessionTemplate().selectOne(getStatement("groupExist"), map);
    }

    @Override
    public List<ReadingGroupRobot> getByActivityId(Long activityId) {
        return getSessionTemplate().selectList(getStatement("getByActivityId"), activityId);
    }

    @Override
    public List<ReadingGroupRobot> getByGroupId(Long groupId) {
        return getSessionTemplate().selectList(getStatement("getByGroupId"), groupId);
    }
}
