package com.pcloud.book.record.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import com.pcloud.book.record.biz.BookBrowseRecordBiz;
import com.pcloud.book.record.entity.BookBrowseRecord;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.ResponseHandleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.record.service.BookBrowseRecordServiceImpl
 * @Author 吴博
 * @Description 书籍浏览埋点内部接口实现类
 * @Date 2020/6/12 16:10
 * @Version 1.0
 **/
@RestController
@RequestMapping("bookBrowseRecordService")
public class BookBrowseRecordServiceImpl implements BookBrowseRecordService {

    @Autowired
    private BookBrowseRecordBiz bookBrowseRecordBiz;

    @Override
    @RequestMapping(value = "addBookRecord", method = RequestMethod.POST)
    public void addBookRecord(@RequestBody BookBrowseRecord bookBrowseRecord) {
        bookBrowseRecordBiz.addBookRecord(bookBrowseRecord);
    }

    @Override
    @RequestMapping(value = "getCityByIP", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<BookBrowseRecord>> getCityByIP(@RequestParam("ip") String ip) {
        return ResponseHandleUtil.toResponse(bookBrowseRecordBiz.getCityByIP(ip));
    }

    @Override
    @RequestMapping(value = "getCitiesByIp", method = RequestMethod.POST)
    public ResponseEntity<ResponseDto<Map<String, String>>> getCitiesByIp(@RequestBody List<String> ips) {
        if (CollUtil.isEmpty(ips)) {
            return ResponseHandleUtil.toResponse(new HashMap<>(0));
        }
        return ResponseHandleUtil.toResponse(bookBrowseRecordBiz.getCitiesByIp(ips));
    }

}