package com.pcloud.book.skill.facade;

import com.pcloud.book.skill.biz.PcloudGroupActivityBiz;
import com.pcloud.book.skill.dto.UpdateActivityShowStateDTO;
import com.pcloud.book.skill.facade.request.GroupActivityClassifyVO;
import com.pcloud.book.skill.facade.request.GroupActivityShowStateVO;
import com.pcloud.book.skill.facade.request.SaveGroupActivityRequestVO;
import com.pcloud.book.skill.facade.request.UpdateGroupActivityRequestVO;
import com.pcloud.book.skill.facade.response.ListGroupActivityResponseVO;
import com.pcloud.book.skill.facade.response.QueryGroupActivityResponseVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;


@RestController
@RequestMapping("groupActivity")
public class PcloudGroupActivityFacade {

    @Resource
    private PcloudGroupActivityBiz pcloudGroupActivityBiz;

    /**
     * 2020/6/22
     * add by pansy
     */
    @ApiOperation("批量修改分类")
    @PostMapping("batchUpdateClassify")
    public ResponseDto<?> batchUpdateClassify(@RequestHeader("token") String token, @RequestBody GroupActivityClassifyVO groupActivityShowStateVO) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        pcloudGroupActivityBiz.batchUpdateClassify(groupActivityShowStateVO);
        return new ResponseDto<>();
    }

    /**
     * 2020/6/22
     * add by pansy
     */
    @ApiOperation("批量上下架")
    @PostMapping("batchUpdateShowState")
    public ResponseDto<Void> batchUpdateShowState(@RequestHeader("token") String token,  @RequestBody GroupActivityShowStateVO groupActivityShowStateVO) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        pcloudGroupActivityBiz.batchUpdateShowState(groupActivityShowStateVO);
        return new ResponseDto<>();
    }


    /**getTempleList
     * 2020/6/22
     * add by pansy
     */
    @ApiOperation("批量删除")
    @PostMapping("deleteByIds")
    public ResponseDto<Void> deleteByIds(@RequestHeader("token") String token, @RequestBody List<Long> ids) throws PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudGroupActivityBiz.deleteByIds(ids);
        return new ResponseDto<>();
    }

    @PostMapping("saveGroupActivity")
    public ResponseDto<Void> saveGroupActivity(@RequestHeader("token") String token, @RequestBody SaveGroupActivityRequestVO vo) throws PermissionException {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        Long partyId = (Long) map.get(SessionUtil.PARTY_ID);
        vo.setAgentId(agentId);
        vo.setUserId(partyId);
        pcloudGroupActivityBiz.saveGroupActivity(vo);
        return new ResponseDto<>();
    }

    @PostMapping("updateGroupActivity")
    public ResponseDto<Void> updateGroupActivity(@RequestHeader("token") String token, @RequestBody UpdateGroupActivityRequestVO vo) throws PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        vo.setUserId(partyId);
        pcloudGroupActivityBiz.updateGroupActivity(vo);
        return new ResponseDto<>();
    }

    @GetMapping("deleteGroupActivity")
    public ResponseDto<Void> deleteGroupActivity(@RequestHeader("token") String token, @RequestParam(value = "id") Long id) throws PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudGroupActivityBiz.deleteGroupActivity(id, partyId);
        return new ResponseDto<>();
    }

    @GetMapping("queryGroupActivity")
    public ResponseDto<PageBeanNew<QueryGroupActivityResponseVO>> queryGroupActivity(@RequestHeader("token") String token,
                                                                                     @RequestParam(value = "name", required = false) String name,
                                                                                     @RequestParam(value = "proLabelId", required = false) Long proLabelId,
                                                                                     @RequestParam(value = "purLabelId", required = false) Long purLabelId,
                                                                                     @RequestParam(value = "depLabelId", required = false) Long depLabelId,
                                                                                     @RequestParam(value = "joinType", required = false) Integer joinType,
                                                                                     @RequestParam(value = "firstClassify", required = false) Long firstClassify,
                                                                                     @RequestParam(value = "secondClassify", required = false) Long secondClassify,
                                                                                     @RequestParam(value = "thirdClassify", required = false) Long thirdClassify,
                                                                                     @RequestParam(value = "gradeLabelId", required = false) Long gradeLabelId,
                                                                                     @RequestParam(value = "subjectLabelId", required = false) Long subjectLabelId,
                                                                                     @RequestParam(value = "cityCode", required = false) String cityCode,
                                                                                     @RequestParam("numPerPage") Integer numPerPage,
                                                                                     @RequestParam("currentPage")  Integer currentPage,
                                                                                     @RequestParam(value = "isChoose", required = false) Integer isChoose,
                                                                                     @RequestParam(value = "groupType", required = false) Integer groupType,
                                                                                     @RequestParam(value = "brandName", required = false) String brandName){
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        return new ResponseDto<>(pcloudGroupActivityBiz.queryGroupActivity(name, proLabelId, purLabelId, depLabelId, joinType,firstClassify,
                secondClassify, thirdClassify, gradeLabelId,subjectLabelId,numPerPage, currentPage,cityCode, agentId, isChoose, groupType, brandName));
    }

    @ApiOperation("获取共读活动列表（弹窗）")
    @GetMapping("listGroupActivity")
    public ResponseDto<PageBeanNew<ListGroupActivityResponseVO>> listGroupActivity(@RequestHeader("token") String token,
                                                                                   @RequestParam(value = "name", required = false) String name,
                                                                                   @RequestParam(value = "joinType", required = false) Integer joinType,
                                                                                   @RequestParam("numPerPage") Integer numPerPage,
                                                                                   @RequestParam("currentPage")  Integer currentPage){
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        return new ResponseDto<>(pcloudGroupActivityBiz.listGroupActivity(name, joinType, numPerPage, currentPage, agentId));
    }

    @PostMapping("updateActivityShowState")
    public ResponseDto<Void> updateActivityShowState(@RequestHeader("token") String token, @RequestBody UpdateActivityShowStateDTO showStateDTO) throws PermissionException {
       SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudGroupActivityBiz.updateActivityShowState(showStateDTO);
        return new ResponseDto<>();
    }


    @ApiOperation("根据id查询")
    @GetMapping("getByActivityId")
    public ResponseDto<?> getByActivityId(@RequestHeader("token") String token, @RequestParam("id") Long id){
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(pcloudGroupActivityBiz.getByActivityId(id));
    }
}
