package com.pcloud.book.timecontrol.mapper;

import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.timecontrol.entity.BookTaskBinding;
import com.pcloud.book.timecontrol.entity.TimeControlTask;
import com.pcloud.book.timecontrol.vo.BookTaskBindingVO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public interface BookTaskBindingMapper {
    int deleteByPrimaryKey(Integer id);

    int insert(BookTaskBinding record);

    int insertSelective(BookTaskBinding record);

    BookTaskBinding selectByPrimaryKey(Integer id);

    int updateByPrimaryKeySelective(BookTaskBinding record);

    int updateByPrimaryKey(BookTaskBinding record);

    /**
     * 批量新增任务配置发布
     */
    int batchInsert(@Param("bookDtos") List<BookDto> bookDtos, @Param("timeControlTask") TimeControlTask timeControlTask);

    /**
     * 获取任务配置发布数量
     */
    Integer getBookTaskBindingCount(@Param("bookIds") List<Integer> bookIds, @Param("proLabelId") Integer proLabelId, @Param("depLabelId") Integer depLabelId, @Param("purLabelId") Integer purLabelId);

    /**
     * 分页查询分页配置发布
     */
    List<BookTaskBindingVO> selectBookTaskBinding4Pcloud(@Param("bookIds") List<Integer> bookIds, @Param("proLabelId") Integer proLabelId, @Param("depLabelId") Integer depLabelId, @Param("purLabelId") Integer purLabelId, @Param("pageNum") Integer pageNum, @Param("numPerPage") Integer numPerPage);

    /**
     * 批量更新任务配置发布状态
     */
    int batchUpdateBookTaskState(@Param("ids") List<Integer> ids, @Param("state") Integer state);

    /**
     * 批量删除任务配置发布
     */
    int batchDeleteBookTask(@Param("ids") List<Integer> ids);

    void deleteByTask(Integer taskId);

    void updateTaskName(@Param("taskId") Integer taskId, @Param("taskName") String taskName);

    /**
     * 查询图书是否与任务模板有过关联
     */
    int checkHasBinding(@Param("bookIds") List<Integer> bookIds, @Param("taskId") Integer taskId);
}