package com.pcloud.book.weixinclock.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

import io.swagger.annotations.ApiModelProperty;

/**
 * @author 杨涛
 * @description 奖励记录表
 * @date 2019/8/23 17:20
 */
public class WeixinClockPrizeRecord extends BaseEntity {

    private static final long serialVersionUID = -8507834064618771705L;

    @ApiModelProperty("主键标识")
    private Long weixinClockPrizeRecordId;

    @ApiModelProperty("微信ID")
    private String wxUserId;

    @ApiModelProperty("微信用户ID")
    private Long wechatUserId;

    @ApiModelProperty("奖励appId")
    private Long clockPrizeId;

    @ApiModelProperty("奖励次数")
    private Integer prizeTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("更新时间")
    private Date updateTime;

    public Long getWeixinClockPrizeRecordId() {
        return weixinClockPrizeRecordId;
    }

    public void setWeixinClockPrizeRecordId(Long weixinClockPrizeRecordId) {
        this.weixinClockPrizeRecordId = weixinClockPrizeRecordId;
    }

    public String getWxUserId() {
        return wxUserId;
    }

    public void setWxUserId(String wxUserId) {
        this.wxUserId = wxUserId;
    }

    public Long getWechatUserId() {
        return wechatUserId;
    }

    public void setWechatUserId(Long wechatUserId) {
        this.wechatUserId = wechatUserId;
    }

    public Long getClockPrizeId() {
        return clockPrizeId;
    }

    public void setClockPrizeId(Long clockPrizeId) {
        this.clockPrizeId = clockPrizeId;
    }

    public Integer getPrizeTime() {
        return prizeTime;
    }

    public void setPrizeTime(Integer prizeTime) {
        this.prizeTime = prizeTime;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public String toString() {
        return "WeixinClockPrizeRecord{" +
                "weixinClockPrizeRecordId=" + weixinClockPrizeRecordId +
                ", wxUserId='" + wxUserId + '\'' +
                ", wechatUserId=" + wechatUserId +
                ", clockPrizeId=" + clockPrizeId +
                ", prizeTime=" + prizeTime +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                '}';
    }
}
