package com.pcloud.book.test;

import com.alibaba.fastjson.JSON;
import com.pcloud.book.BookApplication;
import com.pcloud.book.es.biz.ESBookAndAdviserBiz;
import com.pcloud.book.es.entity.ESBookAndAdviser;
import com.pcloud.universe.commons.paging.Pagination;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.time.StopWatch;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;


@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest(classes = {BookApplication.class, ESBookAndAdviserBizTest.class})
public class ESBookAndAdviserBizTest {

    @Autowired
    private ESBookAndAdviserBiz esBookAndAdviserBiz;



    @Test
    public void testes() {
        StopWatch sw = new StopWatch();
        sw.start();
        String keyword = "9787566602442";
        Pagination<ESBookAndAdviser> p = esBookAndAdviserBiz.getESAdviserBooks4Applet(null,
                keyword, null, null, null,
                0, 100,
                null, null, null, null);

        log.info("key:{},count:{},cost:{}", keyword, p.getTotalCount(), sw.getTime());
        p.getList().forEach((baa) -> log.info(JSON.toJSONString(baa)));

        sw.reset();
        sw.start();
        keyword = "2020秋百年学典三年级";
        p = esBookAndAdviserBiz.getESAdviserBooks4Applet(null,
                keyword, null, null, null,
                0, 100,
                null, null, null, null);

        log.info("key:{},count:{},cost:{}", keyword, p.getTotalCount(), sw.getTime());
        p.getList().forEach((baa) -> log.info(JSON.toJSONString(baa)));

        sw.reset();
        sw.start();
        keyword = "码群书";
        p = esBookAndAdviserBiz.getESAdviserBooks4Applet(null,
                keyword, null, null, null,
                0, 100,
                null, null, null, null);

        log.info("key:{},count:{},cost:{}", keyword, p.getTotalCount(), sw.getTime());
        p.getList().forEach((baa) -> log.info(JSON.toJSONString(baa)));

        sw.reset();
        sw.start();
        keyword = "跟着名师学数学 单元测试卷 六年级第一学期\\n（跟着名师学数学）本书由一线名师编写，紧扣新课标的标准，在内容编排上，结合新教材的要求，设置了以下试卷类型: 阶段基础训练、阶段拓展训练、综合测试卷、期中、期末模拟试卷和参考答案";
        p = esBookAndAdviserBiz.getESAdviserBooks4Applet(null,
                keyword, null, null, null,
                0, 100,
                null, null, null, null);

        log.info("key:{},count:{},cost:{}", keyword, p.getTotalCount(), sw.getTime());
        p.getList().forEach((baa) -> log.info(JSON.toJSONString(baa)));

        sw.stop();
    }

    @Test
    public void testV2() {
        StopWatch sw = new StopWatch();
        sw.start();
        String keyword = "语文";
        Pagination<ESBookAndAdviser> p = esBookAndAdviserBiz.getESAdviserBooks4Applet(null,
                keyword, null, null, null,
                0, 100,
                null, null, null, null);

        log.info("key:{},count:{},cost:{}", keyword, p.getTotalCount(), sw.getTime());
        p.getList().forEach((baa) -> log.info(JSON.toJSONString(baa)));

        sw.reset();
        sw.start();

        p = esBookAndAdviserBiz.getESAdviserBooks4AppletV2(null,
                keyword, null, null, null,
                0, 100,
                null, null, null);

        log.info("key:{},count:{},cost:{}", keyword, p.getTotalCount(), sw.getTime());
        p.getList().forEach((baa) -> log.info(JSON.toJSONString(baa)));

        sw.stop();
    }


}
