package com.pcloud.book.base.dto;

import com.pcloud.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("回复统一参数")
public class ReplyParamDTO extends BaseDto {

    @ApiModelProperty("类型 1 文字 2 图片 3 链接 4应用 5素材")
    private Integer replyType;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("图片地址")
    private String picUrl;

    @ApiModelProperty("应用或作品id")
    private Long serveId;

    @ApiModelProperty("应用或作品类型")
    private String serveType;

    @ApiModelProperty("链接地址")
    private String linkUrl;

    @ApiModelProperty("资源id")
    private Long resourceId;

    @ApiModelProperty("描述")
    private String description;

}
