package com.pcloud.book.keywords.entity;

import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author lily
 * @date 2019/4/24 11:34
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString(callSuper = true)
public class Keyword extends BaseEntity {

    private static final long serialVersionUID = -2337009049174430167L;
    /**
     * 关键词标识
     */
    private Long id;

    /**
     * 引导语
     */
    private String guide;

    /**
     * 关键词
     */
    private String keywords;

    /**
     * 匹配规则
     */
    private Integer matchingRule;

    /**
     * 回复类型
     */
    private Integer replyType;

    /**
     * 是否仓库词
     */
    private Integer isWarehouse;

    /**
     * 服务标识
     */
    private Long serveId;

    /**
     * 服务类型
     */
    private String serveType;

    /**
     * 内容
     */
    private String content;

    /**
     * 图片地址
     */
    private String picUrl;

    /**
     * 链接地址
     */
    private String linkUrl;

    /**
     * 描述信息
     */
    private String description;

    /**
     * 创建人
     */
    private Long createUser;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新用户
     */
    private Long updateUser;

    /**
     * 更新时间
     */
    private Date updateTime;

}
