package com.pcloud.book.mq.topic;

import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.book.personalstage.biz.PersonalStageJumpBiz;
import com.pcloud.book.personalstage.enums.JumpTypeEnum;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.string.StringUtil;
import com.pcloud.wechatgroup.base.constants.WechatGroupConstant;
import com.pcloud.wechatgroup.message.dto.SendTextDTO;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


@Slf4j
@Component("selfRobotSendTextListener")
@RabbitListener(queues = MQTopicConumer.SELF_ROBOT_SEND_TEXT)
public class SelfRobotSendTextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelfRobotSendTextListener.class);

    @Autowired
    private PersonalStageJumpBiz personalStageJumpBiz;

    /**
     * 接收个人号发送文本消息
     */
    @ParamLog("接收个人号文本消息")
    @RabbitHandler
    public void onMessage(SendTextDTO sendTextDTO) throws BizException {
        try {
            LOGGER.info("接收到个人号发送文本消息，处理中："+sendTextDTO.toString());
            //TODO 处理个人号消息
            if (!StringUtil.isEmpty(sendTextDTO.getTextContent()) && sendTextDTO.getTextContent().startsWith(WechatGroupConstant.SELF_ROBOT_CONTENT_KEYWORD)) {
                personalStageJumpBiz.handlePersonalStageJump(sendTextDTO.getWechatGroupId(), sendTextDTO.getWxId(), sendTextDTO.getTextContent(), JumpTypeEnum.ROBOT_TRIGGER);
            }
        } catch (Exception e) {
            LOGGER.error("接收用户发送文本消息失败" + e.getMessage(), e);
        }
    }

}
