package com.pcloud.book.pcloudkeyword.service.impl;

import com.pcloud.book.pcloudKeyword.dto.PcloudRobotDTO;
import com.pcloud.book.pcloudKeyword.dto.RobotClassifyDTO;
import com.pcloud.book.pcloudKeyword.service.PcloudRobotService;
import com.pcloud.book.pcloudkeyword.biz.PcloudRobotBiz;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobot;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.BeanUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RequestMapping("pcloudRobotService")
@RestController("pcloudRobotService")
public class PcloudRobotServiceImpl implements PcloudRobotService {

    @Autowired
    private PcloudRobotBiz pcloudRobotBiz;

    @Override
    @PostMapping("getRobotClassifyBatch")
    public ResponseEntity<ResponseDto<Map<String, RobotClassifyDTO>>> getRobotClassifyBatch(@RequestBody List<String> robotIds) {
        return ResponseHandleUtil.toResponse(pcloudRobotBiz.mapByIds4Classify(robotIds));
    }

    @Override
    @GetMapping("getAllPcloudRobot")
    public ResponseEntity<ResponseDto<List<RobotClassifyDTO>>> getAllPcloudRobot() {
        return ResponseHandleUtil.toResponse(pcloudRobotBiz.getAllPcloudRobot());
    }

    @Override
    @PostMapping("addPcloudRobot")
    public void addPcloudRobot(@RequestBody PcloudRobotDTO pcloudRobotDTO) {
        PcloudRobot pcloudRobot = new PcloudRobot();
        BeanUtils.copyProperties(pcloudRobotDTO, pcloudRobot);
        pcloudRobotBiz.createPcloudRobot(pcloudRobot);
    }

    @Override
    @PostMapping("modifyPcloudRobot")
    public void modifyPcloudRobot(@RequestBody PcloudRobotDTO pcloudRobotDTO) {
        PcloudRobot pcloudRobot = new PcloudRobot();
        BeanUtils.copyProperties(pcloudRobotDTO, pcloudRobot);
        pcloudRobotBiz.updatePcloudRobotByWxId(pcloudRobot);
    }
    @Override
    @GetMapping("getPcloudRobotByType")
    public ResponseEntity<ResponseDto<List<String>>>getPcloudRobotByType(@RequestParam("robotType") Long robotType){
        Integer type = robotType.intValue();
        List<String> allRobot = pcloudRobotBiz.getPcloudRobotByClassify(type);
        return ResponseHandleUtil.toResponse(allRobot);
    }

    @Override
    @PostMapping("getPcloudRobotByRobotIds")
    public ResponseEntity<ResponseDto<Map<String, PcloudRobotDTO>>> getPcloudRobotByRobotIds(@RequestBody List<String> robotIds) {
        Map<String,PcloudRobotDTO> map=new HashMap<>();
        for (String robotId:robotIds) {
            PcloudRobot pcloudRobot = pcloudRobotBiz.getPcloudRobotByWxId(robotId);
            PcloudRobotDTO pcloudRobotDTO=new PcloudRobotDTO();
            BeanUtils.copyProperties(pcloudRobot,pcloudRobotDTO);
            if(pcloudRobot!=null) {
                map.put(robotId, pcloudRobotDTO);
            }

        }
        return ResponseHandleUtil.toResponse(map);
    }

}
