package com.pcloud.book.personalstage.biz;

import com.pcloud.book.personalstage.dto.PersonalStageDTO;
import com.pcloud.book.personalstage.dto.PersonalStageProgressDTO;
import com.pcloud.book.personalstage.entity.PersonalStage;

import com.pcloud.book.personalstage.entity.PersonalStageUser;
import com.pcloud.common.core.mq.DelayQueueDTO;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.page.PageParam;

import java.util.List;

public interface PersonalStageBiz {
    Long createPersonalStage(PersonalStage personalStage);

    void updatePersonalStage(PersonalStage personalStage);

    void deletePersonalStage(Long id);

    PersonalStage getPersonalStage(Long id);

    void updateSeqNum(PersonalStage personalStage);

    /**
     * 获取阶段列表
     * @param robotClassifyId 分类ID
     * @param pageParam 分页参数
     * @return
     * @throws BizException
     */
    PageBean getPersonalStageList(Long robotClassifyId, PageParam pageParam) throws BizException;

    /**
     * 获取阶段列表
     * @param robotClassifyId 分类ID
     * @return
     * @throws BizException
     */
    List<PersonalStageDTO> getPersonalStageListNoPage(Long robotClassifyId) throws BizException;

    void userSendPersonalStage(String userWxId, String ip, Integer code, String robotId, String content);

    Boolean isPersonalStageUser(String robotId);

    void createAddUserStageUser(String robotId, String userWxId, String ip);

    void dealDelayWakeup(DelayQueueDTO dto);

    PersonalStageUser nextStageAddStageUserAndWakeupDelay(String robotId, String userWxId, String ip, Long personalStageId);

    void sendNotKeywordReply(String robotId, String userWxId, String ip, Long personalStageId, Long personalStageUserId);

    void sendNotKeywordFusingReply(String robotId, String userWxId, String ip, Long personalStageId,Long personalStageUserId);

    String replaceProjectProgressUrl(String content, String robotId, String userWxId, Long personalStageUserId);

    void dealDelayFusingFinish(DelayQueueDTO dto);

    PersonalStageProgressDTO getPersonalProgress(String wxUserId, Long personalStageUserId);
}
