package com.pcloud.book.personalstage.dao.impl;

import com.pcloud.book.personalstage.dao.PersonalStageJumpDao;
import com.pcloud.book.personalstage.dto.PersonalStageJumpDto;
import com.pcloud.book.personalstage.entity.PersonalStageJump;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

@Component("personalStageJump")
public class PersonalStageJumpDaoImpl extends BaseDaoImpl<PersonalStageJump> implements PersonalStageJumpDao {
    @Override
    public Integer getCountByPersonalStageId(Long personalStageId) {
        return super.getSqlSession().selectOne(getStatement("getCountByPersonalStageId"), personalStageId);
    }
    @Override
    public PersonalStageJumpDto getDtoById(Long jumpId) {
        return super.getSqlSession().selectOne(getStatement("getDtoById"), jumpId);
    }
}
