package com.pcloud.book.personalstage.dao.impl;

import com.pcloud.book.personalstage.dao.PersonalStageJumpLinkupDao;
import com.pcloud.book.personalstage.entity.PersonalStageJumpLinkup;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

@Component("personalStageJumpLinkup")
public class PersonalStageJumpLinkupDaoImpl extends BaseDaoImpl<PersonalStageJumpLinkup> implements PersonalStageJumpLinkupDao {
    @Override
    public void batchInsert(List<PersonalStageJumpLinkup> personalStageJumpLinkups) {
        super.getSessionTemplate().insert(getStatement("batchInsert"), personalStageJumpLinkups);
    }

    @Override
    public void deleteByJumpId(Long personalStageJumpId) {
        super.sqlSessionTemplate.delete(getStatement("deleteByJumpId"), personalStageJumpId);
    }

    @Override
    public List<PersonalStageJumpLinkup> getByJumpId(Long jumpId) {
        return super.sqlSessionTemplate.selectList(getStatement("getByJumpId"), jumpId);
    }
}
