package com.pcloud.book.personalstage.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


@ApiModel("定制化阶段")
@Data
public class PersonalStage extends BaseEntity {

    @ApiModelProperty("阶段名称")
    private String name;

    @ApiModelProperty("发送阶段非关键词回复语次数")
    private Integer notKeywordFusingCount;

    @ApiModelProperty("触发熔断后几秒恢复正常")
    private Long notKeywordFusingTime;

    @ApiModelProperty("机器人分类id")
    private Long robotClassifyId;

    @ApiModelProperty("排序值")
    private Integer seqNum;

    @ApiModelProperty("显示进度链接")
    private Integer showProgress;

    @ApiModelProperty("阶段非关键词回复集合")
    private List<PersonalStageReply> stageNotKeywordReplies;

    @ApiModelProperty("熔断非关键词恢复集合")
    private List<PersonalStageReply> fusingNotKeywordReplies;

    @ApiModelProperty("唤醒设置集合")
    private List<PersonalStageWakeup> personalStageWakeups;

}