package com.pcloud.book.push.dao;

import com.pcloud.book.push.entity.PushItem;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/4/17 17:46
 **/
public interface PushItemDao extends BaseDao<PushItem> {
    /**
     * 批量插入
     */
    Integer batchInsert(List<PushItem> pushItems);

    /**
     * 根据pushId删除
     * @param pushId
     * @param partyId
     */
    void deleteByPushId(Long pushId, Long partyId);

    /**
     * 根据id删除
     * @param pushItemId
     * @param partyId
     */
    void deleteByPushItemId(Long pushItemId, Long partyId);

    /**
     * 根据pushId获取最大排序值
     * @param pushId
     * @return
     */
    Integer getMaxSeqNumByPushId(Long pushId);

    /**
     * 排序
     * @param pushItemIds
     * @param partyId
     */
    void sortPushItems(List<Long> pushItemIds, Long partyId);

    /**
     * 根据群发id集合查询
     * @param pushIds
     * @return
     */
    List<PushItem> getListByPushIds(List<Long> pushIds);

    /**
     * 根据群发id获取数量
     * @param pushId
     * @return
     */
    Integer getCountByPushId(Long pushId);

    /**
     * 根据群发id获取群发项集合
     * @param pushId
     * @return
     */
    List<PushItem> getListByPushId(Long pushId);

    /**
     * 根据群发id集合查询所有(包括删除了的)
     * @param pushIds
     * @return
     */
    List<PushItem> getAllListByPushIds(List<Long> pushIds);

    /**
     * 根据id集合删除
     */
    void deleteByIds(List<Long> ids, Long partyId);
}
