package com.pcloud.book.timecontrol.mapper;


import com.pcloud.book.timecontrol.dto.SelfPlanUserDto;
import com.pcloud.book.timecontrol.entity.TimeControlSelfPlan;
import com.pcloud.book.timecontrol.vo.SelfPlanVO;
import com.pcloud.book.timecontrol.vo.UpdateSelfPlanVO;

import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("selfPlanMapper")
public interface TimeControlSelfPlanMapper {

    int insert(TimeControlSelfPlan selfPlan);

    int update(TimeControlSelfPlan selfPlan);

    TimeControlSelfPlan getById(@Param("id")Integer id);

    int deleteById(@Param("id")Integer id);

    int getSelfPlanCount(@Param("serviceState") Integer serviceState);

    List<SelfPlanVO> listSelfPlan(@Param("pageNum") int pageNum, @Param("numPerPage") int numPerPage, @Param("serviceState") Integer serviceState);

    void bindTask(@Param("planId") Integer planId, @Param("taskId") Integer taskId);

    @MapKey("wxUserId")
    Map<String, SelfPlanUserDto> getSelfPlanUserDtoMap(List<String> wechatUserIds);

    void updateServiceState(TimeControlSelfPlan timeControlSelfPlan);

    void updatePlanOrder(@Param("id") Integer id, @Param("planOrder") String planOrder);

    void advancedSetting(TimeControlSelfPlan timeControlSelfPlan);

    void updateSelfPlan(UpdateSelfPlanVO updateSelfPlanVO);

    TimeControlSelfPlan getLatestPlan(String wxId);
}