package com.pcloud.book.advertising.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;

/**
 * @description 日期数量DTO
 * @author PENG
 * @date 2017年6月11日 下午2:08:30
 * @version 1.0
 */
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class DateCountDTO implements Serializable {

    private static final long serialVersionUID = 4234798666223706295L;

    /**
	 * 日期
	 */
	private String date;

	/**
	 * 曝光量
	 */
	private Long exposureNum;

    /**
     * 点击量
     */
	private Long clickNum;

    /**
     * 收益
     */
	private BigDecimal income;

	public String getDate() {
		return date;
	}

	public void setDate(String date) {
		this.date = date;
	}

    public Long getExposureNum() {
        return exposureNum;
    }

    public void setExposureNum(Long exposureNum) {
        this.exposureNum = exposureNum;
    }

    public Long getClickNum() {
        return clickNum;
    }

    public void setClickNum(Long clickNum) {
        this.clickNum = clickNum;
    }

    public BigDecimal getIncome() {
        return income;
    }

    public void setIncome(BigDecimal income) {
        this.income = income;
    }

    @Override
    public String toString() {
        return "DateCountDTO{" +
                "date='" + date + '\'' +
                ", exposureNum=" + exposureNum +
                ", clickNum=" + clickNum +
                ", income=" + income +
                '}';
    }
}
