package com.pcloud.book.group.dto;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.group.entity.BookGroupServe;
import com.pcloud.common.dto.BaseDto;

/**
 * 社群书群二维码DTO
 * @author PENG
 * @date 2019年4月17日11:31:16
 */
public class BookGroupDTO extends BaseDto {

    private static final long serialVersionUID = 7620868422261683212L;

    /**
     * book_group.id (唯一标识)
     */
    private Long id;

    /**
     * book_group.book_id (书刊ID)
     */
    private Long bookId;

    /**
     * book_group.channel_id (运营ID)
     */
    private Long channelId;

    /**
     * book_group.channel_id (运营ID)
     */
    private Long sceneId;

    /**
     * book_group.group_qrcode_url (群二维码图片)
     */
    private String groupQrcodeUrl;

    /**
     * book_group.group_qrcode_name (群二维码名称)
     */
    private String groupQrcodeName;

    /**
     * book_group.pro_label_id (专业标签ID)
     */
    private Long proLabelId;

    /**
     * 专业标签名称
     */
    private String proLabelName;

    /**
     * book_group.dep_label_id (深度标签ID)
     */
    private Long depLabelId;

    /**
     * 深度标签名称
     */
    private String depLabelName;

    /**
     * book_group.pur_label_id (目的标签ID)
     */
    private Long purLabelId;

    /**
     * 目的标签名称
     */
    private String purLabelName;

    /**
     * 选择群页面标题
     */
    private String joinTitle;

    /**
     * book_group.join_slogan (进群宣传语)
     */
    private String joinSlogan;

    /**
     * book_group.personal_qrcode_url (个人二维码)
     */
    private String personalQrcodeUrl;

    /**
     * book_group.product_id (商品ID)
     */
    private Long productId;

    /**
     * book_group.create_user (创建人)
     */
    private Long createUser;

    /**
     * book_group.create_time (创建时间)
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * book_group.update_time (修改时间)
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    /**
     * book_group.is_delete (是否删除)
     */
    private Boolean isDelete;

    /**
     * 书刊信息
     */
    private BookDto bookInfo;

    /**
     * 书刊封面
     */
    private String bookImg;

    /**
     * isbn号
     */
    private String isbn;

    private String bookName;

    /**
     * 编号
     */
    private String bookNumber;

    private String url;

    private Long bookClockInfoId;

    /**
     * 是否显示书名
     */
    private Boolean isShowBookName;

    /**
     * 进群方式：1群二维码，2客服机器人
     */
    private Integer joinGroupType;

    /**
     * 加好友欢迎语
     */
    private String addFriendGuide;

    /**
     * 客服称谓
     */
    private String customerServiceName;

    /**
     * 是否邀请入群
     */
    private Boolean isInviteGroup;

    /**
     * 社群书暗号
     */
    private String bookGroupCipher;

    /**
     * 出版社id(编辑所属)
     */
    private Long agentId;
    /**
     * 出版社名称(编辑所属)
     */
    private String agentName;

    /**
     * 出版社(书所属)
     */
    private String publish;

    /**
     * 1v1上次推送更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastPushUpdateTime;

    /**
     * 1v1是否在上次推送更新之后有新的更新
     */
    private Boolean isSomeUpdate;

    /**
     * 1V1社群书下的资源
     */
    private List<BookGroupServe> bookGroupServes;

    /**
     * 判断关联状态
     */
    private Boolean assocState;

    /**
     * 是否属于特殊出版社
     */
    private Boolean belongSpecialAgent;
    /**
     * 书籍简称
     */
    private String shortBookName;


    /**
     * 年级标签id
     */
    private Long graLabelId;

    /**
     * 科目标签id
     */
    private Long subLabelId;

    /**
     * 版本标签id
     */
    private Long verLabelId;

    /**
     * 地域标签id
     */
    private Long areaLabelId;


    /**
     * 年级标签名称
     */
    private String graLabelName;

    /**
     * 科目标签名称
     */
    private String subLabelName;

    /**
     * 版本标签名称
     */
    private String verLabelName;

    /**
     * 地域标签名称
     */
    private String areaLabelName;

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public String getGroupQrcodeUrl() {
        return groupQrcodeUrl;
    }

    public void setGroupQrcodeUrl(String groupQrcodeUrl) {
        this.groupQrcodeUrl = groupQrcodeUrl;
    }

    public String getGroupQrcodeName() {
        return groupQrcodeName;
    }

    public void setGroupQrcodeName(String groupQrcodeName) {
        this.groupQrcodeName = groupQrcodeName;
    }

    public Long getSceneId() {
        return sceneId;
    }

    public void setSceneId(Long sceneId) {
        this.sceneId = sceneId;
    }
    public Long getProLabelId() {
        return proLabelId;
    }

    public void setProLabelId(Long proLabelId) {
        this.proLabelId = proLabelId;
    }

    public Long getDepLabelId() {
        return depLabelId;
    }

    public void setDepLabelId(Long depLabelId) {
        this.depLabelId = depLabelId;
    }

    public Long getPurLabelId() {
        return purLabelId;
    }

    public void setPurLabelId(Long purLabelId) {
        this.purLabelId = purLabelId;
    }

    public String getJoinTitle() {
        return joinTitle;
    }

    public void setJoinTitle(String joinTitle) {
        this.joinTitle = joinTitle;
    }

    public String getJoinSlogan() {
        return joinSlogan;
    }

    public void setJoinSlogan(String joinSlogan) {
        this.joinSlogan = joinSlogan;
    }

    public String getPersonalQrcodeUrl() {
        return personalQrcodeUrl;
    }

    public void setPersonalQrcodeUrl(String personalQrcodeUrl) {
        this.personalQrcodeUrl = personalQrcodeUrl;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Boolean getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Boolean isDelete) {
        this.isDelete = isDelete;
    }

    public String getProLabelName() {
        return proLabelName;
    }

    public void setProLabelName(String proLabelName) {
        this.proLabelName = proLabelName;
    }

    public String getDepLabelName() {
        return depLabelName;
    }

    public void setDepLabelName(String depLabelName) {
        this.depLabelName = depLabelName;
    }

    public String getPurLabelName() {
        return purLabelName;
    }

    public void setPurLabelName(String purLabelName) {
        this.purLabelName = purLabelName;
    }

    public BookDto getBookInfo() {
        return bookInfo;
    }

    public void setBookInfo(BookDto bookInfo) {
        this.bookInfo = bookInfo;
    }

    public String getBookImg() {
        return bookImg;
    }

    public void setBookImg(String bookImg) {
        this.bookImg = bookImg;
    }

    public String getIsbn() {
        return isbn;
    }

    public void setIsbn(String isbn) {
        this.isbn = isbn;
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public Long getBookClockInfoId() {
        return bookClockInfoId;
    }

    public void setBookClockInfoId(Long bookClockInfoId) {
        this.bookClockInfoId = bookClockInfoId;
    }

    public Boolean getIsShowBookName() {
        return isShowBookName;
    }

    public void setIsShowBookName(Boolean isShowBookName) {
        this.isShowBookName = isShowBookName;
    }


    public Integer getJoinGroupType() {
        return joinGroupType;
    }

    public void setJoinGroupType(Integer joinGroupType) {
        this.joinGroupType = joinGroupType;
    }

    public String getBookNumber() {
        return bookNumber;
    }

    public void setBookNumber(String bookNumber) {
        this.bookNumber = bookNumber;
    }

    public String getAddFriendGuide() {
        return addFriendGuide;
    }

    public void setAddFriendGuide(String addFriendGuide) {
        this.addFriendGuide = addFriendGuide;
    }

    public String getCustomerServiceName() {
        return customerServiceName;
    }

    public void setCustomerServiceName(String customerServiceName) {
        this.customerServiceName = customerServiceName;
    }

    public Boolean getIsInviteGroup() {
        return isInviteGroup;
    }

    public void setIsInviteGroup(Boolean isInviteGroup) {
        this.isInviteGroup = isInviteGroup;
    }

    public String getBookGroupCipher() {
        return bookGroupCipher;
    }

    public void setBookGroupCipher(String bookGroupCipher) {
        this.bookGroupCipher = bookGroupCipher;
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getPublish() {
        return publish;
    }

    public void setPublish(String publish) {
        this.publish = publish;
    }

    public Date getLastPushUpdateTime() {
        return lastPushUpdateTime;
    }

    public void setLastPushUpdateTime(Date lastPushUpdateTime) {
        this.lastPushUpdateTime = lastPushUpdateTime;
    }

    public Boolean getIsSomeUpdate() {
        return isSomeUpdate;
    }

    public void setIsSomeUpdate(Boolean isSomeUpdate) {
        this.isSomeUpdate = isSomeUpdate;
    }

    public List<BookGroupServe> getBookGroupServes() {
        return bookGroupServes;
    }

    public void setBookGroupServes(List<BookGroupServe> bookGroupServes) {
        this.bookGroupServes = bookGroupServes;
    }

    public Boolean getAssocState() {
        return assocState;
    }

    public void setAssocState(Boolean assocState) {
        this.assocState = assocState;
    }

    public Boolean getBelongSpecialAgent() {
        return belongSpecialAgent;
    }

    public void setBelongSpecialAgent(Boolean belongSpecialAgent) {
        this.belongSpecialAgent = belongSpecialAgent;
    }

    public String getShortBookName() {
        return shortBookName;
    }

    public void setShortBookName(String shortBookName) {
        this.shortBookName = shortBookName;
    }

    public Long getGraLabelId() {
        return graLabelId;
    }

    public void setGraLabelId(Long graLabelId) {
        this.graLabelId = graLabelId;
    }

    public Long getSubLabelId() {
        return subLabelId;
    }

    public void setSubLabelId(Long subLabelId) {
        this.subLabelId = subLabelId;
    }

    public Long getVerLabelId() {
        return verLabelId;
    }

    public void setVerLabelId(Long verLabelId) {
        this.verLabelId = verLabelId;
    }

    public Long getAreaLabelId() {
        return areaLabelId;
    }

    public void setAreaLabelId(Long areaLabelId) {
        this.areaLabelId = areaLabelId;
    }

    public String getGraLabelName() {
        return graLabelName;
    }

    public void setGraLabelName(String graLabelName) {
        this.graLabelName = graLabelName;
    }

    public String getSubLabelName() {
        return subLabelName;
    }

    public void setSubLabelName(String subLabelName) {
        this.subLabelName = subLabelName;
    }

    public String getVerLabelName() {
        return verLabelName;
    }

    public void setVerLabelName(String verLabelName) {
        this.verLabelName = verLabelName;
    }

    public String getAreaLabelName() {
        return areaLabelName;
    }

    public void setAreaLabelName(String areaLabelName) {
        this.areaLabelName = areaLabelName;
    }

    @Override
    public String toString() {
        return "BookGroupDTO{" +
                "id=" + id +
                ", bookId=" + bookId +
                ", channelId=" + channelId +
                ", sceneId=" + sceneId +
                ", groupQrcodeUrl='" + groupQrcodeUrl + '\'' +
                ", groupQrcodeName='" + groupQrcodeName + '\'' +
                ", proLabelId=" + proLabelId +
                ", proLabelName='" + proLabelName + '\'' +
                ", depLabelId=" + depLabelId +
                ", depLabelName='" + depLabelName + '\'' +
                ", purLabelId=" + purLabelId +
                ", purLabelName='" + purLabelName + '\'' +
                ", joinTitle='" + joinTitle + '\'' +
                ", joinSlogan='" + joinSlogan + '\'' +
                ", personalQrcodeUrl='" + personalQrcodeUrl + '\'' +
                ", productId=" + productId +
                ", createUser=" + createUser +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", isDelete=" + isDelete +
                ", bookInfo=" + bookInfo +
                ", bookImg='" + bookImg + '\'' +
                ", isbn='" + isbn + '\'' +
                ", bookName='" + bookName + '\'' +
                ", bookNumber='" + bookNumber + '\'' +
                ", url='" + url + '\'' +
                ", bookClockInfoId=" + bookClockInfoId +
                ", isShowBookName=" + isShowBookName +
                ", joinGroupType=" + joinGroupType +
                ", addFriendGuide='" + addFriendGuide + '\'' +
                ", customerServiceName='" + customerServiceName + '\'' +
                ", isInviteGroup=" + isInviteGroup +
                ", bookGroupCipher='" + bookGroupCipher + '\'' +
                ", agentId=" + agentId +
                ", agentName='" + agentName + '\'' +
                ", publish='" + publish + '\'' +
                ", lastPushUpdateTime=" + lastPushUpdateTime +
                ", isSomeUpdate=" + isSomeUpdate +
                ", bookGroupServes=" + bookGroupServes +
                ", assocState=" + assocState +
                ", belongSpecialAgent=" + belongSpecialAgent +
                ", shortBookName='" + shortBookName + '\'' +
                ", graLabelId=" + graLabelId +
                ", subLabelId=" + subLabelId +
                ", verLabelId=" + verLabelId +
                ", areaLabelId=" + areaLabelId +
                ", graLabelName=" + graLabelName +
                ", subLabelName=" + subLabelName +
                ", verLabelName=" + verLabelName +
                ", areaLabelName=" + areaLabelName +
                "} " + super.toString();
    }
}