package com.pcloud.book.group.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 戴兴
 * @description TODO
 * @date 2019/7/23 15:28
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ListBookGroup4ChannelParamVO implements Serializable {

    @ApiModelProperty("当前页")
    private Integer currentPage;

    @ApiModelProperty("每页条数")
    private Integer numPerPage;

    @ApiModelProperty("搜索的关键词")
    private String keywords;

    @ApiModelProperty("开始时间")
    private String startTime;

    @ApiModelProperty("结束时间")
    private String endTime;

    @ApiModelProperty("是否是基金书 0-否，1-是")
    private Integer isFundBook;

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getNumPerPage() {
        return numPerPage;
    }

    public void setNumPerPage(Integer numPerPage) {
        this.numPerPage = numPerPage;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Integer getIsFundBook() {
        return isFundBook;
    }

    public void setIsFundBook(Integer isFundBook) {
        this.isFundBook = isFundBook;
    }

    @Override
    public String toString() {
        return "ListBookGroup4ChannelParamVO{" +
                "currentPage=" + currentPage +
                ", numPerPage=" + numPerPage +
                ", keywords='" + keywords + '\'' +
                ", startTime=" + startTime +
                ", endTime=" + endTime +
                ", isFundBook=" + isFundBook +
                '}';
    }
}