package com.pcloud.book.pcloudkeyword.dao.impl;

import com.pcloud.book.pcloudkeyword.dao.PcloudKeywordDao;
import com.pcloud.book.pcloudkeyword.entity.PcloudKeyword;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("pcloudKeywordDao")
public class PcloudKeywordDaoImpl extends BaseDaoImpl<PcloudKeyword> implements PcloudKeywordDao {

    @Override
    public List<Long> getIdsByClassifyId(Long keywordClassifyId) {
        return getSessionTemplate().selectList(getStatement("getIdsByClassifyId"), keywordClassifyId);
    }

    @Override
    public void deleteByClassifyId(Long keywordClassifyId) {
        getSessionTemplate().delete(getStatement("deleteByClassifyId"), keywordClassifyId);
    }

    @Override
    public PcloudKeyword getByClassifyIdAndName(Integer type, Long pcloudClassifyId, String name) {
        Map<String,Object> map=new HashMap<>();
        map.put("type",type);
        map.put("pcloudClassifyId",pcloudClassifyId);
        map.put("name",name);
        return getSessionTemplate().selectOne(getStatement("getByClassifyIdAndName"), map);
    }
}
