package com.pcloud.book.pcloudkeyword.dao.impl;

import com.pcloud.book.pcloudKeyword.dto.RobotClassifyDTO;
import com.pcloud.book.pcloudkeyword.dao.PcloudRobotDao;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobot;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("pcloudRobotDao")
public class PcloudRobotDaoImpl extends BaseDaoImpl<PcloudRobot> implements PcloudRobotDao {

    @Override
    public PcloudRobot getByWxId(String wxId) {
        return super.getSqlSession().selectOne(getStatement("getByWxId"), wxId);
    }

    @Override
    public PcloudRobot getPcloudRobotByType(Integer robotType) {
        return super.getSqlSession().selectOne(getStatement("getPcloudRobotByType"), robotType);
    }

    @Override
    public void updateWakeUpByClassifyIds(List<Integer> list) {
        this.getSessionTemplate().update(this.getStatement("updateWakeUpByClassifyIds"), list);
    }

    @Override
    public void clearWakeUp() {
        this.getSessionTemplate().update(this.getStatement("clearWakeUp"));
    }

    @Override
    public Map<String, RobotClassifyDTO> mapByIds4Classify(List<String> robotIds) {
        return this.getSessionTemplate().selectMap(this.getStatement("mapByIds4Classify"),robotIds,"wxId");
    }

    @Override
    public List<RobotClassifyDTO> getAllPcloudRobot() {
        return this.getSessionTemplate().selectList(this.getStatement("getAllPcloudRobot"));
    }

    @Override
    public PcloudRobot getByUniqueNumber(String uniqueNumber) {
        return this.getSessionTemplate().selectOne(this.getStatement("getByUniqueNumber"), uniqueNumber);
    }

}
