/**
 * 
 */
package com.pcloud.common.core.biz;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.MQQueueConstant;
import com.pcloud.common.core.dto.ConvertQueueDto;
import com.pcloud.common.exceptions.BizException;

/**
 * @描述：
 * 
 * @作者：songx
 * @创建时间：2017年2月27日,下午2:49:38 @版本：1.0
 */
@Service("convertQueueBiz")
public class ConvertQueueBizImpl implements ConvertQueueBiz {

	@Autowired
	private AmqpTemplate amqpTemplate;

	/**
	 * 通知转码(音视频)
	 */
	@Override
	@ParamLog("通知转码(音视频)QUEUE")
	public void sendConvertFileQueue(ConvertQueueDto convertFileQueueDto) throws BizException {
		if (convertFileQueueDto == null) {
			throw BizException.PARAM_IS_NULL;
		}
		amqpTemplate.convertAndSend(MQQueueConstant.CONVERT, convertFileQueueDto);
	}

}
