package com.pcloud.common.core.biz;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.MQQueueConstant;
import com.pcloud.common.core.dto.ExapiMessageDto;

@Component("exapiQueueBiz")
public class ExapiQueueBizImpl implements ExapiQueueBiz {

	@Autowired
	private AmqpTemplate amqpTemplate;

	@Override
	@ParamLog("发送对外API queue")
	public void sendMessageQueue(ExapiMessageDto exapiMessageDto) {
		amqpTemplate.convertAndSend(MQQueueConstant.EXAPI, exapiMessageDto);
	}

}
