package com.pcloud.common.utils.pdf.po;

import com.pcloud.common.utils.pdf.enums.PdfAlignEnum;

/**
 * 
 * @author：songx
 * @date：2017年12月7日,下午9:01:00
 */
public class PdfImagePO extends PdfPO {

	/**
	 * 
	 */
	private static final long serialVersionUID = 4336343171137731129L;

	/**
	 * 图片地址，本地路径或者网络路径
	 */
	private String imageUrl;

	/**
	 * 图片byte数组
	 */
	private byte[] imageByte;

	/**
	 * 长度
	 */
	private int height;

	/**
	 * 宽度
	 */
	private int width;

	public PdfImagePO(String imageUrl, PdfAlignEnum pdfAlignEnum) {
		super();
		this.imageUrl = imageUrl;
		setPdfAlignEnum(pdfAlignEnum);
	}

	public PdfImagePO(String imageUrl, PdfAlignEnum pdfAlignEnum, int height, int width) {
		super();
		this.imageUrl = imageUrl;
		this.height = height;
		this.width = width;
		setPdfAlignEnum(pdfAlignEnum);
	}

	public PdfImagePO(byte[] imageByte, PdfAlignEnum pdfAlignEnum) {
		super();
		this.imageByte = imageByte;
		setPdfAlignEnum(pdfAlignEnum);
	}

	public PdfImagePO(byte[] imageByte, PdfAlignEnum pdfAlignEnum, int height, int width) {
		super();
		this.imageByte = imageByte;
		this.height = height;
		this.width = width;
		setPdfAlignEnum(pdfAlignEnum);
	}

	public String getImageUrl() {
		return imageUrl;
	}

	public void setImageUrl(String imageUrl) {
		this.imageUrl = imageUrl;
	}

	public byte[] getImageByte() {
		return imageByte;
	}

	public void setImageByte(byte[] imageByte) {
		this.imageByte = imageByte;
	}

	public int getHeight() {
		return height;
	}

	public void setHeight(int height) {
		this.height = height;
	}

	public int getWidth() {
		return width;
	}

	public void setWidth(int width) {
		this.width = width;
	}

}
