package com.pcloud.book.book.service.impl;

import com.pcloud.book.book.biz.BookFundBiz;
import com.pcloud.book.book.dto.BookFundDto;
import com.pcloud.book.book.dto.BookFundInfoDto;
import com.pcloud.book.book.service.BookFundService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @描述：
 * 
 * @作者：lihao
 * @创建时间：2017年7月21日,下午5:28:29 @版本：1.0
 */
@RestController("bookFundService")
@RequestMapping("bookFundService")
public class BookFundServiceImpl implements BookFundService {

	@Autowired
	private BookFundBiz bookFundBiz;

	/**
	 * 判断书刊某时间是否被买断
	 */
	@Override
	@RequestMapping(value = "/isFundOccupy", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<Boolean>> isFundOccupy(
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "date", required = false) String date) throws BizException {
		return ResponseHandleUtil.toResponse(bookFundBiz.isFundOccupy(bookId, date));
	}

	/**
	 * 批量获取书刊基金总额
	 */
	@Override
	@RequestMapping(value = "/getBookFundMoney", method = RequestMethod.POST)
	public ResponseEntity<ResponseDto<Map<Long, BigDecimal>>> getBookFundMoney(
			@RequestBody(required = false) List<Long> bookIds) throws BizException {
		return ResponseHandleUtil.toResponse(bookFundBiz.getBookFundMoney(bookIds));
	}

	/**
	 * 获取图书在基金支持的基金名称
	 */
	@Override
	@RequestMapping(value = "/getUseFundName", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<String>> getUseFundName(
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "useDate", required = false) String useDate) throws BizException {
		return ResponseHandleUtil.toResponse(bookFundBiz.getUseFundName(bookId, useDate));
	}

	/**
	 * 获取图书下的所有基金信息
	 */
	@Override
	@RequestMapping(value = "/getByBookId", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<List<BookFundDto>>> getByBookId(
			@RequestParam(value = "bookId", required = false) Long bookId) throws BizException {
		return ResponseHandleUtil.toResponse(bookFundBiz.getByBookId(bookId));
	}

	/**
	 * 正在基金支持的图书
	 */
	@Override
	@RequestMapping(value = "/getHaveFundBook", method = RequestMethod.POST)
	public ResponseEntity<ResponseDto<Long>> getHaveFundBook(@RequestBody(required = false) List<Long> bookIds)
			throws BizException {
		return ResponseHandleUtil.toResponse(bookFundBiz.getHaveFundBook(bookIds));
	}
	
	/**
	 * 正在基金支持的图书列表
	 */
	@Override
	@RequestMapping(value = "/listHaveFundBooks", method = RequestMethod.POST)
	public ResponseEntity<ResponseDto<List<Long>>> listHaveFundBooks(@RequestBody(required = false) List<Long> bookIds)
			throws BizException {
		return ResponseHandleUtil.toResponse(bookFundBiz.listHaveFundBooks(bookIds));
	}
	/**
	 * 获取所有正在基金支持的图书列表
	 */
	@Override
	@RequestMapping(value = "/listAllHaveFundBooks", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<List<Long>>> listAllHaveFundBooks()
			throws BizException {
		return ResponseHandleUtil.toResponse(bookFundBiz.listAllHaveFundBooks());
	}

	/**
	 * 获取图书在基金支持的基金信息
	 */
	@Override
	@RequestMapping(value = "/getUseFundInfo", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<BookFundInfoDto>> getUseFundInfo(
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "useDate", required = false) String useDate) throws BizException {
		return ResponseHandleUtil.toResponse(bookFundBiz.getUseFundInfo(bookId,useDate));
	}

	@Override
	@GetMapping("getIsHaveFundBefore")
	public ResponseEntity<ResponseDto<Boolean>> getIsHaveFundBefore(@RequestParam("bookId")Long bookId) throws BizException {
		return ResponseHandleUtil.toResponse(bookFundBiz.getIsHaveFundBefore(bookId));
	}
}
