package com.pcloud.book.group.entity;

import java.util.Date;
import com.pcloud.common.entity.BaseEntity;

/**
 * 社群书群二维码实体
 * @author PENG
 * @date 2019年4月17日11:31:16
 */
public class BookGroup extends BaseEntity {

    private static final long serialVersionUID = 7446049698462097220L;

    /**
     * book_group.id (唯一标识)
     */
    private Long id;

    /**
     * book_group.book_id (书刊ID)
     */
    private Long bookId;

    /**
     * book_group.channel_id (运营ID)
     */
    private Long channelId;

    /**
     * 二维码标识
     */
    private Long sceneId;

    /**
     * book_group.group_qrcode_url (群二维码图片)
     */
    private String groupQrcodeUrl;

    /**
     * book_group.group_qrcode_name (群二维码名称)
     */
    private String groupQrcodeName;

    /**
     * book_group.pro_label_id (专业标签ID)
     */
    private Long proLabelId;

    /**
     * book_group.dep_label_id (深度标签ID)
     */
    private Long depLabelId;

    /**
     * book_group.pur_label_id (目的标签ID)
     */
    private Long purLabelId;

    /**
     * 选择群页面标题
     */
    private String joinTitle;

    /**
     * book_group.join_slogan (进群宣传语)
     */
    private String joinSlogan;

    /**
     * book_group.personal_qrcode_url (个人二维码)
     */
    private String personalQrcodeUrl;

    /**
     * book_group.product_id (商品ID)
     */
    private Long productId;

    /**
     * book_group.create_user (创建人)
     */
    private Long createUser;

    /**
     * book_group.create_time (创建时间)
     */
    private Date createTime;

    /**
     * book_group.update_time (修改时间)
     */
    private Date updateTime;

    /**
     * book_group.is_delete (是否删除)
     */
    private Boolean isDelete;

    /**
     * 是否展示书名
     */
    private Boolean isShowBookName;

    /**
     * 进群方式：1群二维码，2客服机器人
     */
    private Integer joinGroupType;

    /**
     * 加好友欢迎语
     */
    private String addFriendGuide;

    /**
     * 客服称谓
     */
    private String customerServiceName;

    /**
     * 是否邀请入群
     */
    private Boolean isInviteGroup;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public String getGroupQrcodeUrl() {
        return groupQrcodeUrl;
    }

    public void setGroupQrcodeUrl(String groupQrcodeUrl) {
        this.groupQrcodeUrl = groupQrcodeUrl;
    }

    public String getGroupQrcodeName() {
        return groupQrcodeName;
    }

    public void setGroupQrcodeName(String groupQrcodeName) {
        this.groupQrcodeName = groupQrcodeName;
    }

    public Long getProLabelId() {
        return proLabelId;
    }

    public void setProLabelId(Long proLabelId) {
        this.proLabelId = proLabelId;
    }

    public Long getDepLabelId() {
        return depLabelId;
    }

    public void setDepLabelId(Long depLabelId) {
        this.depLabelId = depLabelId;
    }

    public Long getPurLabelId() {
        return purLabelId;
    }

    public void setPurLabelId(Long purLabelId) {
        this.purLabelId = purLabelId;
    }

    public String getJoinTitle() {
        return joinTitle;
    }

    public void setJoinTitle(String joinTitle) {
        this.joinTitle = joinTitle;
    }

    public String getJoinSlogan() {
        return joinSlogan;
    }

    public void setJoinSlogan(String joinSlogan) {
        this.joinSlogan = joinSlogan;
    }

    public String getPersonalQrcodeUrl() {
        return personalQrcodeUrl;
    }

    public void setPersonalQrcodeUrl(String personalQrcodeUrl) {
        this.personalQrcodeUrl = personalQrcodeUrl;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Boolean getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Boolean isDelete) {
        this.isDelete = isDelete;
    }

    public Long getSceneId() {
        return sceneId;
    }

    public void setSceneId(Long sceneId) {
        this.sceneId = sceneId;
    }

    public Boolean getIsShowBookName() {
        return isShowBookName;
    }

    public void setIsShowBookName(Boolean isShowBookName) {
        this.isShowBookName = isShowBookName;
    }

    public Integer getJoinGroupType() {
        return joinGroupType;
    }

    public void setJoinGroupType(Integer joinGroupType) {
        this.joinGroupType = joinGroupType;
    }

    public String getAddFriendGuide() {
        return addFriendGuide;
    }

    public void setAddFriendGuide(String addFriendGuide) {
        this.addFriendGuide = addFriendGuide;
    }

    public String getCustomerServiceName() {
        return customerServiceName;
    }

    public void setCustomerServiceName(String customerServiceName) {
        this.customerServiceName = customerServiceName;
    }

    public Boolean getIsInviteGroup() {
        return isInviteGroup;
    }

    public void setIsInviteGroup(Boolean isInviteGroup) {
        this.isInviteGroup = isInviteGroup;
    }

    @Override
    public String toString() {
        return "BookGroup{" +
                "id=" + id +
                ", bookId=" + bookId +
                ", channelId=" + channelId +
                ", sceneId=" + sceneId +
                ", groupQrcodeUrl='" + groupQrcodeUrl + '\'' +
                ", groupQrcodeName='" + groupQrcodeName + '\'' +
                ", proLabelId=" + proLabelId +
                ", depLabelId=" + depLabelId +
                ", purLabelId=" + purLabelId +
                ", joinTitle='" + joinTitle + '\'' +
                ", joinSlogan='" + joinSlogan + '\'' +
                ", personalQrcodeUrl='" + personalQrcodeUrl + '\'' +
                ", productId=" + productId +
                ", createUser=" + createUser +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", isDelete=" + isDelete +
                ", isShowBookName=" + isShowBookName +
                ", joinGroupType=" + joinGroupType +
                ", addFriendGuide='" + addFriendGuide + '\'' +
                ", customerServiceName='" + customerServiceName + '\'' +
                ", isInviteGroup=" + isInviteGroup +
                "} " + super.toString();
    }
}