package com.pcloud.book.weixinclock.facade;

import com.pcloud.book.group.vo.BookGroupClassifyVO;
import com.pcloud.book.group.vo.ListGroupClassifyParam;
import com.pcloud.book.weixinclock.dto.WeixinClockDto;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * @author 杨涛
 * @description 接口层
 * @date 2019/8/14 19:15
 */
@FeignClient(value = "pcloud-service-book",qualifier = "weixinClockFacadeCloud",path = "weixinClock")
@Api(description = "微信群签到打卡")
public interface WeixinClockFacade {

    @ApiOperation(value = "创建微信群签到打卡", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
                        @ApiImplicitParam(name = "weixinClockDto", value = "微信群签到打卡实体", dataType = "WeixinClockDto", paramType = "body")})
    @RequestMapping(value = "createWeixinClock", method = RequestMethod.POST)
    ResponseDto<?> createWeixinClock(@RequestHeader("token") String token, @RequestBody WeixinClockDto weixinClockDto)
            throws BizException, PermissionException;

    @ApiOperation(value = "获取微信群签到打卡信息", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "weixinClockId", value = "weixinClockId", dataType = "Long", paramType = "query")})
    @RequestMapping(value = "getWeixinClockBaseInfo", method = RequestMethod.GET)
    ResponseDto<?> getWeixinClockBaseInfo(@RequestHeader("token") String token,
                                          @RequestParam(value = "weixinClockId",required = false) Long weixinClockId)
            throws BizException, PermissionException;

    @ApiOperation(value = "获取编辑所有的分类", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
                        @ApiImplicitParam(name = "listGroupClassifyParam", value = "获取分类列表参数", dataType = "ListGroupClassifyParam", paramType = "body")})
    @RequestMapping(value = "listGroupClassify4Clock", method = RequestMethod.POST)
    ResponseDto<PageBeanNew<BookGroupClassifyVO>> listGroupClassify4Clock(@RequestHeader("token") String token, @RequestBody @ApiParam("获取分类列表参数") ListGroupClassifyParam listGroupClassifyParam)
            throws PermissionException;

    @ApiOperation(value = "修改微信群签到打卡", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
                        @ApiImplicitParam(name = "weixinClockDto", value = "微信群签到打卡实体", dataType = "WeixinClockDto", paramType = "body")})
    @RequestMapping(value = "updateWeixinClock", method = RequestMethod.POST)
    ResponseDto<?> updateWeixinClock(@RequestHeader("token") String token, @RequestBody WeixinClockDto weixinClockDto)
            throws BizException, PermissionException;

    @ApiOperation(value = "删除微信群签到打卡", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "weixinClockId", value = "weixinClockId", dataType = "Long", paramType = "query")})
    @RequestMapping(value = "deleteWeixinClock", method = RequestMethod.GET)
    ResponseDto<?> deleteWeixinClock(@RequestHeader("token") String token, @RequestParam(value = "weixinClockId",required = false)Long weixinClockId)
            throws BizException, PermissionException;

    @ApiOperation(value = "微信群签到打卡列表(编辑端)")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "keyword", value = "打卡关键字", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "Integer", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页大小", dataType = "Integer", paramType = "query")})
    @RequestMapping(value = "listWeixinClock4Adviser", method = RequestMethod.GET)
    ResponseDto<?> listWeixinClock4Adviser(@RequestHeader("token") String token,
                                           @RequestParam(value = "keyword" ,required = false) String keyword,
                                           @RequestParam(value = "currentPage", required = false) Integer currentPage,
                                           @RequestParam(value = "numPerPage", required = false) Integer numPerPage)
            throws BizException, PermissionException ;

    @ApiOperation(value = "获取某个微信群签到打卡的所有群分类详情", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "weixinClockId", value = "weixinClockId", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "Integer", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页大小", dataType = "Integer", paramType = "query")
    })
    @RequestMapping(value = "listGroupClassifyDetail4Clock", method = RequestMethod.GET)
    ResponseDto<?> listGroupClassifyDetail4Clock(@RequestHeader("token") String token,
                                                 @RequestParam("weixinClockId") Long weixinClockId,
                                                 @RequestParam(value = "currentPage", required = false) Integer currentPage,
                                                 @RequestParam(value = "numPerPage", required = false) Integer numPerPage)
            throws BizException, PermissionException ;

    @ApiOperation("获取某个群内的打卡排行榜")
    @ApiImplicitParams({@ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "string", paramType = "header"),
                        @ApiImplicitParam(name = "wxGroupId", value = "wxGroupId", dataType = "string", paramType = "query"),
                        @ApiImplicitParam(name = "wxUserId", value = "wxUserId", dataType = "string", paramType = "query"),
                        @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "Integer", paramType = "query"),
                        @ApiImplicitParam(name = "numPerPage", value = "每页大小", dataType = "Integer", paramType = "query")})
    @RequestMapping(value = "listWeixinClockRank", method = RequestMethod.GET)
    ResponseDto<?> listWeixinClockRank(@CookieValue("userInfo")String userInfo,
                                       @RequestParam(value = "wxGroupId", required = false) String wxGroupId,
                                       @RequestParam(value = "wxUserId", required = false) String wxUserId,
                                       @RequestParam(value = "currentPage", required = false) Integer currentPage,
                                       @RequestParam(value = "numPerPage", required = false) Integer numPerPage)
            throws BizException, PermissionException;

    @ApiOperation("获取某个群内某个用户的信息")
    @ApiImplicitParams({@ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "wxGroupId", value = "wxGroupId", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "wxUserId", value = "wxUserId", dataType = "string", paramType = "query")
    })
    @RequestMapping(value = "getClockWechatUserRank", method = RequestMethod.GET)
    ResponseDto<?> getClockWechatUserRank(@CookieValue("userInfo")String userInfo,
                                          @RequestParam(value = "wxGroupId", required = false) String wxGroupId,
                                          @RequestParam(value = "wxUserId", required = false) String wxUserId)
            throws BizException, PermissionException;

}
