package com.pcloud.book.consumer.trade;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.facade.tradecenter.dto.*;
import com.pcloud.facade.tradecenter.service.OrderFormService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author:lili
 * @Desr:交易调用
 * @Date:2019/5/7 17:22
 */
@Component("tradeConsr")
public class TradeConsr {

    /**
     * logger
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(TradeConsr.class);
    @Autowired
    private OrderFormService orderFormService;

    public Map<Long, QrGroupBuyDetailDto> getQrGroupSaleDetail(List<Long> qrcodeIds) throws BizException {
        if (ListUtils.isEmpty(qrcodeIds)) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseMapResponse(orderFormService.getQrGroupSaleDetail(qrcodeIds)
                    , Long.class, QrGroupBuyDetailDto.class);
        } catch (Exception e) {
            LOGGER.error("获取购买次数.[getQrGroupSaleDetail]:" + e.getMessage(), e);
        }
        return null;
    }

    /**
     * 获取交易额
     * @param wechatGroupDto
     * @return
     * @throws BizException
     */
    public Map<Long, GroupMoneyDto> getQrGroupSaleMoney(WechatGroupDto wechatGroupDto) throws BizException {
        Map<Long, GroupMoneyDto> map = new HashMap<>();
        if (wechatGroupDto == null) {
            return map;
        }
        try {
            ResponseEntity<ResponseDto<Map<Long, GroupMoneyDto>>> responseEntityP = orderFormService.getQrGroupSaleMoney(wechatGroupDto);
            map = ResponseHandleUtil.parseMap(responseEntityP, Long.class, GroupMoneyDto.class);
        } catch (Exception e) {
            LOGGER.error("获取交易额.[getQrGroupSaleMoney]:" + e.getMessage(), e);
        }
        if (map == null) {
            map = new HashMap<>();
        }
        return map;
    }

    /**
     * 获取购买人数量
     */
    public Map<Long, GroupMoneyDto> getSpeQrGroupSaleMoney(SpeWechatGroupDto speWechatGroupDto) throws BizException{
        Map<Long, GroupMoneyDto> map = new HashMap<>();
        if (speWechatGroupDto == null) {
            return map;
        }
        try {
            ResponseEntity<ResponseDto<Map<Long, GroupMoneyDto>>> responseEntityP = orderFormService.getSpeQrGroupSaleMoney(speWechatGroupDto);
            map = ResponseHandleUtil.parseMap(responseEntityP, Long.class, GroupMoneyDto.class);
        } catch (Exception e) {
            LOGGER.error("获取交易额.[获取购买人数量]:" + e.getMessage(), e);
        }
        if (map == null) {
            map = new HashMap<>();
        }
        return map;
    }

    @ParamLog("根据微信群id查询销售情况")
    public List<SaleDetailByQrcodeDto> getSaleDetailByQrcodeId(Long qrcodeId) throws BizException{
        List<SaleDetailByQrcodeDto> list=new ArrayList<>();
        if (qrcodeId == null) {
            return list;
        }
        try {
            ResponseEntity<ResponseDto<List<SaleDetailByQrcodeDto>>> responseEntity = orderFormService.getSaleDetailByQrcodeId(qrcodeId);
            list = ResponseHandleUtil.parseListResponse(responseEntity, SaleDetailByQrcodeDto.class);
        } catch (Exception e) {
            LOGGER.error("根据微信群id查询销售情况:" + e.getMessage(), e);
        }
        if (list == null) {
            list = new ArrayList<>();
        }
        return list;
    }

    @ParamLog("根据微信群id和wechatUserId查询销售额")
    public BigDecimal getAmountByQrcodeId(Long qrcodeId,Long wechatUserId) throws BizException{
        BigDecimal amount=BigDecimal.ZERO;
        if (qrcodeId == null) {
            return amount;
        }
        try {
            ResponseEntity<ResponseDto<BigDecimal>> responseEntity = orderFormService.getAmountByQrcodeId(qrcodeId,wechatUserId);
            amount = ResponseHandleUtil.parseResponse(responseEntity, BigDecimal.class);
        } catch (Exception e) {
            LOGGER.error("根据微信群id和wechatUserId查询销售额:" + e.getMessage(), e);
        }
        if (amount == null) {
            amount = BigDecimal.ZERO;
        }
        return amount;
    }

    @ParamLog("获取用户购买或者参与过的社群码ID")
    public List<Long> getBuyBookGroupIdList(Long channelId, Long wechatUserId) throws BizException {
        List<Long> results = new ArrayList<>();
        try {
            ResponseEntity<ResponseDto<List<Long>>> responseEntity = orderFormService.getBuyBookGroupIdList(wechatUserId, channelId);
            results = ResponseHandleUtil.parseListResponse(responseEntity, Long.class);
        } catch (Exception e) {
            LOGGER.error("获取用户购买或者参与过的社群码ID详情:" + e.getMessage(), e);
        }
        return results;
    }

}
