package com.pcloud.book.group.dao.impl;

import com.google.common.collect.Maps;

import com.pcloud.book.advertising.dto.WeixinClassifyInfoDTO;
import com.pcloud.book.group.dao.GroupQrcodeDao;
import com.pcloud.book.group.dto.*;
import com.pcloud.book.group.entity.GroupQrcode;
import com.pcloud.book.group.vo.GroupQrcodeBaseInfoVO;
import com.pcloud.book.group.vo.ListGroupQrcodeResponseVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/17 16:38
 */
@Component("groupQrcodeDao")
public class GroupQrcodeDaoImpl extends BaseDaoImpl<GroupQrcode> implements GroupQrcodeDao {
    @Override
    public void updateGroupQrcode(Long groupQrcodeId, String qrcodeUrl, Long userId) {
        final Map<String, Object> map = Maps.newHashMap();
        map.put("groupQrcodeId", groupQrcodeId);
        map.put("qrcodeUrl", qrcodeUrl);
        map.put("userId", userId);
        this.getSqlSession().update(this.getStatement("updateGroupQrcode"), map);
    }

    @Override
    public List<ListGroupQrcodeResponseVO> listAllGroupQrcode(String groupName) {
        return this.getSqlSession().selectList(this.getStatement("listAllGroupQrcode"), groupName);
    }

    @Override
    public void deleteByClassifyId(Long classifyId) {
        this.getSqlSession().update(this.getStatement("deleteByClassifyId"), classifyId);
    }

    @Override
    public Map<Long, GroupAndUserNumberDTO> listGroupAndUserNumber(List<Long> classifyIds) {
        return  this.getSqlSession().selectMap(this.getStatement("listGroupAndUserNumber"), classifyIds, "classifyId");

    }

    @Override
    public void modifyNameById(String wechatGroupName, Long id, Long updateUser) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("wechatGroupName", wechatGroupName);
        paramMap.put("updateUser", updateUser);
        this.getSqlSession().update(this.getStatement("modifyNameById"), paramMap);
    }

    @Override
    public void updateQrUrl(UpdateQrDTO updateQrDTO) {
        this.getSqlSession().update(this.getStatement("updateQrUrl"), updateQrDTO);
    }

    @Override
    public List<ChangeGroupNameDTO> getWechatGroupInfo(List<Long> ids) {
        return this.getSqlSession().selectList(this.getStatement("getWechatGroupInfo"), ids);
    }

    @Override
    public void syncWeixinGroupId(Long weixinQrcodeId, String weixinGroupId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("weixinQrcodeId", weixinQrcodeId);
        paramMap.put("weixinGroupId", weixinGroupId);
        this.getSqlSession().update(this.getStatement("syncWeixinGroupId"), paramMap);
    }

    @Override
    public void updateUserNumber(String wechatGroupId, Integer memberCount) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("memberCount", memberCount);
        paramMap.put("weixinGroupId", wechatGroupId);
        this.getSqlSession().update(this.getStatement("updateUserNumber"), paramMap);
    }

    @Override
    public GroupQrcodeDTO getGroupQrcodeInfo(String weixinGroupId) {
        return this.getSqlSession().selectOne(this.getStatement("getGroupQrcodeInfo"), weixinGroupId);

    }

    @Override
    public void updateUseState(Long id, Integer useState) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("useState", useState);
        this.getSqlSession().update(this.getStatement("updateUseState"), paramMap);
    }

    @Override
    public Integer changeQrcodeState(Long id, Integer qrcodeState) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("qrcodeState", qrcodeState);
        return this.getSqlSession().update(this.getStatement("changeQrcodeState"), paramMap);
    }

    @Override
    public Map<Long, GroupQrcodeInfoDTO> listQrcodeInfoByIds(List<Long> groupQrcodeIds) {
        return this.getSqlSession().selectMap(this.getStatement("listQrcodeInfoByIds"), groupQrcodeIds, "id");
    }

    @Override
    public GroupQrcodeBaseInfoVO getBaseById(Long groupQrcodeId) {
        return this.getSqlSession().selectOne(this.getStatement("getBaseById"), groupQrcodeId);
    }

    @Override
    public ChangeGroupNameDTO getUpdateGroupNameParam(Long id) {
        return this.getSqlSession().selectOne(this.getStatement("getUpdateGroupNameParam"), id);
    }

    @Override
    public List<String> getWeixinGroupIdsByBookGroupId(Long bookGroupId) {
        return this.getSqlSession().selectList(this.getStatement("getWeixinGroupIdsByBookGroupId"), bookGroupId);
    }

    @Override
    public List<String> getWeixinGroupIdsByClassifyId(Long classifyId) {
        return this.getSqlSession().selectList(this.getStatement("getWeixinGroupIdsByClassifyId"), classifyId);
    }

    @Override
    public GroupQrcode getGroupQrcodeByGroupId(String wechatGroupId) {
        return this.getSqlSession().selectOne(this.getStatement("getGroupQrcodeByGroupId"), wechatGroupId);
    }

    @Override
    public Integer countByClassifyIds(List<Long> classifyIds) {
        return this.getSqlSession().selectOne(this.getStatement("countByClassifyIds"), classifyIds);
    }

    @Override
    public List<String> getWeixinGroupIdsByClassifyIdList(List<Long> classifyIds) {
        return this.getSqlSession().selectList(this.getStatement("getWeixinGroupIdsByClassifyIdList"), classifyIds);
    }

    @Override
    public List<Long> getIdsByClassifyId(Long classifyId) {
        return this.getSqlSession().selectList(this.getStatement("getIdsByClassifyId"), classifyId);
    }

    @Override
    public void updateGroupName(Long id, String groupName) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("groupName", groupName);
        this.getSqlSession().update(this.getStatement("updateGroupName"), paramMap);
    }

    @Override
    public List<GroupQrcode> getListByUserCount(Integer userCount) {
        return this.getSqlSession().selectList(this.getStatement("getListByUserCount"), userCount);
    }

    @Override
    public List<GroupQrcodeInfo4Advertising> getGroupInfo4AdvertisingByWxGroupIds(List<String> wxGroupIds) {
        return this.getSqlSession().selectList(this.getStatement("getGroupInfo4AdvertisingByWxGroupIds"), wxGroupIds);
    }

    @Override
    public List<Long> listQrcodeIdsByLabelQuery(Map<String, Object> paramMap) {
        return this.getSqlSession().selectList(getStatement("listQrcodeIdsByLabelQuery"),paramMap);
    }

    @Override
    public List<WeixinClassifyInfoDTO> getGroupInfoByQrcodeId(List<Long> ids) {
        Map<String, Object> map = new HashMap<>();
        map.put("ids", ids);
        return this.getSqlSession().selectList(getStatement("getGroupInfoByQrcodeId"),map);
    }

    @Override
    public List<Long> filterDeleteQrcodeId(List<String> wxGroupIdList) {
        return this.getSqlSession().selectList(this.getStatement("filterDeleteQrcodeId"), wxGroupIdList);
    }

    @Override
    public List<GroupQrcodeFoAdDTO> GroupQrcodeFoAdDTOSByClassifyIds(List<Long> classifyIds) {
        return this.getSqlSession().selectList(this.getStatement("GroupQrcodeFoAdDTOSByClassifyIds"), classifyIds);
    }

    @Override
    public void updateRiddleOpenStatus(Long qrcodeId, Boolean status) {
        Map<String, Object> map = new HashMap<>();
        map.put("qrcodeId", qrcodeId);
        map.put("status", status);
        getSessionTemplate().update(getStatement("updateRiddleOpenStatus"), map);
    }

}
