package com.pcloud.book.riddle.dao;

import com.pcloud.book.riddle.dto.GroupRiddleDTO;
import com.pcloud.book.riddle.entity.RiddleRecord;
import com.pcloud.common.core.dao.BaseDao;

/**
 * @描述：猜谜记录
 * @作者：zhuyajie
 * @创建时间：18:18 2019/7/24
 * @版本：1.0
 */
public interface RiddleRecordDao extends BaseDao<RiddleRecord> {


    /**
     * 获取上一条猜谜记录
     * @param wxGroupId
     * @return
     */
    RiddleRecord getLastRecordByWxGroupId(String wxGroupId);

    /**
     * 获得答对题目数量
     * @param wxGroupId
     * @return
     */
    Integer getCorrectCountByGroup(String wxGroupId, Integer finishCount);

    /**
     * 获取参与次数、人数
     * @param wxGroupId
     * @return
     */
    public GroupRiddleDTO getParticipateCount(String wxGroupId);
}
