package com.pcloud.book.weixinclock.biz;

import com.pcloud.book.group.vo.BookGroupClassifyVO;
import com.pcloud.book.group.vo.ListGroupClassifyParam;
import com.pcloud.book.weixinclock.dto.RankDto;
import com.pcloud.book.weixinclock.dto.WeixinClockDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;

import java.util.List;
import java.util.Map;

/**
 * @author 杨涛
 * @description TODO
 * @date 2019/8/14 19:11
 */
public interface WeixinClockBiz {

    /**
     * 创建微信群签到打卡
     * @param weixinClockDto
     */
    Long createWeixinClock(WeixinClockDto weixinClockDto) throws BizException;

    /**
     * 获取编辑所有的分类
     * @param listGroupClassifyParam
     */
    PageBeanNew<BookGroupClassifyVO> listGroupClassify4Clock(ListGroupClassifyParam listGroupClassifyParam, Long adviserId) throws BizException;

    /**
     * 删除微信群签到打卡
     * @param weixinClockId
     */
    void deleteWeixinClock(Long weixinClockId, Long adviserId) throws BizException;

    /**
     * 修改微信群签到打卡
     * @param weixinClockDto
     */
    void updateWeixinClock(WeixinClockDto weixinClockDto) throws BizException;

    /**
     * 微信群签到打卡列表(编辑端)
     * @param pageParam
     */
    PageBeanNew<WeixinClockDto> listWeixinClock4Adviser(PageParam pageParam, Map<String,Object> paramMap) throws BizException;

    /**
     * 获取微信群签到打卡信息
     * @param weixinClockId
     */
    WeixinClockDto getWeixinClockBaseInfo(Long weixinClockId) throws BizException;

    /**
     * 获取某个微信群签到打卡的所有群分类详情
     * @param weixinClockId
     */
    PageBeanNew<BookGroupClassifyVO> listGroupClassifyDetail4Clock(Long weixinClockId, Integer currentPage, Integer numPerPage) throws BizException;

    /**
     * 校验是否为该群的打卡关键字
     * @param weixinGroupId
     */
    Boolean checkWeixinClockKeyword(String content, String weixinGroupId) throws BizException;

    /**
     * 发送关键词信息
     * @param content
     * @param userWxId
     * @return
     */
    Boolean sendKeywordMessage(String content, String userWxId, String wechatGroupId,String wxId, String ip);

    /**
     * 获取某个群内的打卡排行榜
     * @param wxGroupId
     * @return
     */
    List<RankDto> listWeixinClockRank(String wxGroupId, String wxUserId);
}
