package com.pcloud.book.weixinclock.biz.impl;

import com.google.common.collect.Lists;

import com.pcloud.appcenter.app.dto.AppDto;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.clock.dto.PushBookClockKeywordDTO;
import com.pcloud.book.consumer.app.AppConsr;
import com.pcloud.book.consumer.channel.QrcodeSceneConsr;
import com.pcloud.book.consumer.reader.ReaderConsr;
import com.pcloud.book.consumer.wechatgroup.WechatGroupConsr;
import com.pcloud.book.group.biz.BookGroupClassifyBiz;
import com.pcloud.book.group.dao.BookGroupClassifyDao;
import com.pcloud.book.group.dto.GroupClassifyQrcodeDTO;
import com.pcloud.book.group.vo.BookGroupClassifyVO;
import com.pcloud.book.group.vo.ListGroupClassifyParam;
import com.pcloud.book.weixinclock.biz.WeixinClockBiz;
import com.pcloud.book.weixinclock.dao.WeixinClockDao;
import com.pcloud.book.weixinclock.dao.WeixinClockGroupClassifyDao;
import com.pcloud.book.weixinclock.dao.WeixinClockMemberDao;
import com.pcloud.book.weixinclock.dao.WeixinClockRewardDao;
import com.pcloud.book.weixinclock.dao.WeixinClockTopicDao;
import com.pcloud.book.weixinclock.dto.DrawRewardDto;
import com.pcloud.book.weixinclock.dto.RankDto;
import com.pcloud.book.weixinclock.dto.WeixinClockDto;
import com.pcloud.book.weixinclock.entity.WeixinClock;
import com.pcloud.book.weixinclock.entity.WeixinClockGroupClassify;
import com.pcloud.book.weixinclock.entity.WeixinClockMember;
import com.pcloud.book.weixinclock.entity.WeixinClockTopic;
import com.pcloud.channelcenter.base.constants.ChannelConstants;
import com.pcloud.channelcenter.wechat.dto.AccountSettingDto;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.MQTopicProducer;
import com.pcloud.common.core.constant.ProductTypeConstant;
import com.pcloud.common.core.constant.WXKeywordOperationConstant;
import com.pcloud.common.core.dto.PromotionGiftDto;
import com.pcloud.common.core.dto.PromotionOrderDto;
import com.pcloud.common.core.enums.PromotionOrderEnum;
import com.pcloud.common.enums.AppTypeEnum;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.DateNewUtils;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.common.utils.cache.redis.JedisClusterUtils;
import com.pcloud.common.utils.httpclient.UrlUtils;
import com.pcloud.common.utils.string.StringUtil;
import com.pcloud.labelcenter.label.service.LabelService;
import com.pcloud.wechatgroup.group.dto.GroupUserDTO;
import com.sdk.wxgroup.SendTextMessageVO;
import com.sdk.wxgroup.WxGroupSDK;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author 杨涛
 * @description TODO
 * @date 2019/8/14 19:12
 */
@Component("weixinClockBiz")
public class WeixinClockBizImpl implements WeixinClockBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(WeixinClockBizImpl.class);

    @Autowired
    private WeixinClockDao weixinClockDao;
    @Autowired
    private BookGroupClassifyDao bookGroupClassifyDao;
    @Autowired
    private WechatGroupConsr wechatGroupConsr;
    @Autowired
    private LabelService labelService;
    @Autowired
    private WeixinClockRewardDao weixinClockRewardDao;
    @Autowired
    private WeixinClockGroupClassifyDao weixinClockGroupClassifyDao;
    @Autowired
    private AppConsr appConsr;
    @Autowired
    private WeixinClockMemberDao weixinClockMemberDao;
    @Autowired
    private WeixinClockTopicDao weixinClockTopicDao;
    @Autowired
    private BookGroupClassifyBiz bookGroupClassifyBiz;
    @Autowired
    private QrcodeSceneConsr qrcodeSceneConsr;
    @Autowired
    private AmqpTemplate amqpTemplate;
    @Autowired
    private ReaderConsr readerConsr;

    @Value("${wechat.group.link.prefix}")
    private String wechatGroupLinkPrefix;


    /**
     * 关创建微信群签到打卡
     * @param weixinClockDto
     */
    @Override
    @ParamLog("创建微信群签到打卡")
    @Transactional(rollbackFor = Exception.class)
    public Long createWeixinClock(WeixinClockDto weixinClockDto) throws BizException {
        if(null == weixinClockDto) {
            throw new BookBizException(BookBizException.ERROR,"缺少必要参数！");
        }
        WeixinClock weixinClock = new WeixinClock();
        BeanUtils.copyProperties(weixinClockDto, weixinClock);
        Long weixinClockId = weixinClockDao.insert(weixinClock);
        if(!ListUtils.isEmpty(weixinClockDto.getGroupClassifyIds())) {
            List<WeixinClockGroupClassify> groupClassifyIds = Lists.newArrayList();
            weixinClockDto.getGroupClassifyIds().forEach(e -> {
                WeixinClockGroupClassify weixinClockGroupClassify = new WeixinClockGroupClassify();
                weixinClockGroupClassify.setBookGroupClassifyId(e);
                weixinClockGroupClassify.setWeixinClockId(weixinClockId);
                groupClassifyIds.add(weixinClockGroupClassify);
            });
            weixinClockGroupClassifyDao.batchInsert(groupClassifyIds);
        }
        if(!ListUtils.isEmpty(weixinClockDto.getWeixinClockRewards())) {
            weixinClockDto.getWeixinClockRewards().forEach(e -> e.setWeixinClockId(weixinClockId));
            weixinClockRewardDao.batchInsert(weixinClockDto.getWeixinClockRewards());
        }
        return weixinClockId;
    }

    @Override
    @ParamLog("获取编辑所有的分类")
    public PageBeanNew<BookGroupClassifyVO> listGroupClassify4Clock(ListGroupClassifyParam listGroupClassifyParam, Long adviserId) throws BizException {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("adviserId", adviserId);
        if (!StringUtil.isEmpty(listGroupClassifyParam.getName())) {
            paramMap.put("name", listGroupClassifyParam.getName());
        }
        paramMap.put("bookIds", listGroupClassifyParam.getBookIds());
        paramMap.put("proLabelId",listGroupClassifyParam.getProLabelId());
        paramMap.put("depLabelId",listGroupClassifyParam.getDepLabelId());
        paramMap.put("purLabelId",listGroupClassifyParam.getPurLabelId());
        PageParam pageParam = new PageParam(listGroupClassifyParam.getCurrentPage(), listGroupClassifyParam.getNumPerPage());
        PageBeanNew<BookGroupClassifyVO> pageBeanNew = bookGroupClassifyDao.listPageNew(pageParam, paramMap, "listGroupClassify4Clock");
        if (pageBeanNew == null) {
            return new PageBeanNew<>(listGroupClassifyParam.getCurrentPage(), listGroupClassifyParam.getNumPerPage(), new ArrayList<>());
        }
        //遍历填充标签
        List<BookGroupClassifyVO> bookGroupClassifyVOS = pageBeanNew.getRecordList();
        if (!ListUtils.isEmpty(bookGroupClassifyVOS)) {
            List<Long> labelIds = new ArrayList<>();
            List<Long> classifyIds = new ArrayList<>();
            for (BookGroupClassifyVO bookGroupClassifyVO : bookGroupClassifyVOS) {
                classifyIds.add(bookGroupClassifyVO.getClassifyId());
                if (bookGroupClassifyVO.getProLabelId() != null) {
                    labelIds.add(bookGroupClassifyVO.getProLabelId());
                }
                if (bookGroupClassifyVO.getPurLabelId() != null) {
                    labelIds.add(bookGroupClassifyVO.getPurLabelId());
                }
                if (bookGroupClassifyVO.getDepLabelId() != null) {
                    labelIds.add(bookGroupClassifyVO.getDepLabelId());
                }
            }
            Map<Long, Integer> activeCountMap = wechatGroupConsr.get7DayActiveUserCountByClassify(classifyIds);
            Map<Long, String> labelMap = new HashMap<>();
            if (!ListUtils.isEmpty(labelIds)) {
                labelMap = ResponseHandleUtil.parseMap(labelService.getLabelName(labelIds), Long.class, String.class);
            }
            for (BookGroupClassifyVO bookGroupClassifyVO : bookGroupClassifyVOS) {
                if (!MapUtils.isEmpty(labelMap)) {
                    Long proLabelId = bookGroupClassifyVO.getProLabelId();
                    Long purLabelId = bookGroupClassifyVO.getPurLabelId();
                    Long depLabelId = bookGroupClassifyVO.getDepLabelId();
                    if (proLabelId != null) {
                        bookGroupClassifyVO.setProLabelName(labelMap.get(proLabelId));
                    }
                    if (purLabelId != null) {
                        bookGroupClassifyVO.setPurLabelName(labelMap.get(purLabelId));
                    }
                    if (depLabelId != null) {
                        bookGroupClassifyVO.setDepLabelName(labelMap.get(depLabelId));
                    }
                }
                Integer count = activeCountMap.get(bookGroupClassifyVO.getClassifyId());
                if (count == null) {
                    bookGroupClassifyVO.setWeekActiveNumber(0);
                } else {
                    bookGroupClassifyVO.setWeekActiveNumber(count);
                }
            }
        }
        return pageBeanNew;
    }

    /**
     * 删除微信群签到打卡
     * @param weixinClockId
     * @param adviserId
     */
    @Override
    @ParamLog("删除微信群签到打卡")
    @Transactional(rollbackFor = Exception.class)
    public void deleteWeixinClock(Long weixinClockId, Long adviserId) throws BizException {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("weixinClockId",weixinClockId);
        //删除对应的群分类
        weixinClockGroupClassifyDao.deleteById(weixinClockId);
        //删除对应的奖励信息
        weixinClockRewardDao.deleteById(weixinClockId);
        //删除主表的微信群签到打卡
        weixinClockDao.deleteWeixinClock(paramMap);
    }

    /**
     * 修改微信群签到打卡
     * @param weixinClockDto
     * @throws BizException
     */
    @Override
    @ParamLog("修改微信群签到打卡")
    @Transactional(rollbackFor = Exception.class)
    public void updateWeixinClock(WeixinClockDto weixinClockDto) throws BizException {
        Long weixinClockId = weixinClockDto.getWeixinClockId();
        WeixinClock weixinClock = new WeixinClock();
        BeanUtils.copyProperties(weixinClockDto, weixinClock);
        weixinClockDao.update(weixinClock);
        //删除对应的群分类
        weixinClockGroupClassifyDao.deleteById(weixinClockId);
        //删除对应的基本信息
        weixinClockRewardDao.deleteById(weixinClockId);
        if(!ListUtils.isEmpty(weixinClockDto.getGroupClassifyIds())) {
            List<WeixinClockGroupClassify> groupClassifyIds = Lists.newArrayList();
            weixinClockDto.getGroupClassifyIds().forEach(e -> {
                WeixinClockGroupClassify weixinClockGroupClassify = new WeixinClockGroupClassify();
                weixinClockGroupClassify.setBookGroupClassifyId(e);
                weixinClockGroupClassify.setWeixinClockId(weixinClockId);
                groupClassifyIds.add(weixinClockGroupClassify);
            });
            weixinClockGroupClassifyDao.batchInsert(groupClassifyIds);
        }
        if(!ListUtils.isEmpty(weixinClockDto.getWeixinClockRewards())) {
            weixinClockDto.getWeixinClockRewards().forEach(e -> e.setWeixinClockId(weixinClockId));
            weixinClockRewardDao.batchInsert(weixinClockDto.getWeixinClockRewards());
        }
    }

    @Override
    public PageBeanNew<WeixinClockDto> listWeixinClock4Adviser(PageParam pageParam, Map<String, Object> paramMap) throws BizException {
        PageBeanNew<WeixinClockDto> clockDtoPage = weixinClockDao.listPageNew(pageParam, paramMap, "listWeixinClock4Adviser");
        if (clockDtoPage == null) {
            return new PageBeanNew<>(pageParam.getPageNum(), pageParam.getNumPerPage(), 0, new ArrayList<>());
        }
        List<Long> appIds = clockDtoPage.getRecordList().stream().map(WeixinClockDto::getClockPrizeId).collect(Collectors.toList());
        if(!ListUtils.isEmpty(appIds)) {
            Map<Long, AppDto> resultsMap = appConsr.getBaseByIds(appIds);
            for(WeixinClockDto weixinClockDto:clockDtoPage.getRecordList()){
                if(null != resultsMap && resultsMap.containsKey(weixinClockDto.getClockPrizeId())){
                    AppDto appDto = resultsMap.get(weixinClockDto.getClockPrizeId());
                    DrawRewardDto drawRewardDto = new DrawRewardDto();
                    drawRewardDto.setAppId(weixinClockDto.getClockPrizeId());
                    drawRewardDto.setChannelId(appDto.getChannelId());
                    drawRewardDto.setSquareImg(appDto.getSquareImg());
                    drawRewardDto.setTitle(appDto.getTitle());
                    drawRewardDto.setTypeCode(appDto.getTypeCode());
                    weixinClockDto.setDrawRewardDto(drawRewardDto);
                }
            }
        }
        return clockDtoPage == null ? new PageBeanNew() : clockDtoPage;
    }

    @Override
    public WeixinClockDto getWeixinClockBaseInfo(Long weixinClockId) throws BizException {
        WeixinClockDto weixinClockDto = weixinClockDao.getWeixinClockBaseInfo(weixinClockId);
        if(null != weixinClockDto && null != weixinClockDto.getClockPrizeId() && !weixinClockDto.getClockPrizeId().equals(0L)) {
            AppDto appDto = appConsr.getBaseById(weixinClockDto.getClockPrizeId());
            DrawRewardDto drawRewardDto = new DrawRewardDto();
            drawRewardDto.setAppId(weixinClockDto.getClockPrizeId());
            drawRewardDto.setChannelId(appDto.getChannelId());
            drawRewardDto.setSquareImg(appDto.getSquareImg());
            drawRewardDto.setTitle(appDto.getTitle());
            drawRewardDto.setTypeCode(appDto.getTypeCode());
            weixinClockDto.setDrawRewardDto(drawRewardDto);
        }
        return weixinClockDto == null ? new WeixinClockDto() : weixinClockDto;
    }

    @Override
    @ParamLog("获取某个微信群签到打卡的所有群分类详情")
    public PageBeanNew<BookGroupClassifyVO> listGroupClassifyDetail4Clock(Long weixinClockId, Integer currentPage, Integer numPerPage) throws BizException {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("weixinClockId", weixinClockId);
        PageParam pageParam = new PageParam(currentPage, numPerPage);
        PageBeanNew<BookGroupClassifyVO> pageBeanNew = weixinClockDao.listPageNew(pageParam, paramMap, "listGroupClassifyDetail4Clock");
        if (pageBeanNew == null) {
            return new PageBeanNew<>(currentPage, numPerPage, 0, new ArrayList<>());
        }
        List<BookGroupClassifyVO> bookGroupClassifyVOS = pageBeanNew.getRecordList();
        if (!ListUtils.isEmpty(bookGroupClassifyVOS)) {
            List<Long> classifyIds = bookGroupClassifyVOS.stream().map(BookGroupClassifyVO::getClassifyId).collect(Collectors.toList());
            Map<Long, Integer> activeCountMap = wechatGroupConsr.get7DayActiveUserCountByClassify(classifyIds);
            for (BookGroupClassifyVO bookGroupClassifyVO : bookGroupClassifyVOS) {
                //最近7天活跃人数
                Integer count = activeCountMap.get(bookGroupClassifyVO.getClassifyId());
                if (count == null) {
                    bookGroupClassifyVO.setWeekActiveNumber(0);
                } else {
                    bookGroupClassifyVO.setWeekActiveNumber(count);
                }
            }
        }
        return pageBeanNew == null ? new PageBeanNew() : pageBeanNew;
    }

    @Override
    @ParamLog("校验是否为该群的打卡关键字")
    public Boolean checkWeixinClockKeyword(String content, String weixinGroupId) throws BizException {
        //简单过滤非关键词的词
        if (StringUtil.isEmpty(content) || content.length() > 10) {
            return null;
        }
        //通过群id获取对应基本信息
        GroupClassifyQrcodeDTO classifyQrcodeInfo = bookGroupClassifyBiz.getClassifyQrcodeInfo(weixinGroupId);
        if(null == classifyQrcodeInfo){
            return null;
        }
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookGroupClassifyId",classifyQrcodeInfo.getClassifyId());
        String aimKeyword = weixinClockGroupClassifyDao.getKeywordByGroupClassify(paramMap);
        return content.equals(aimKeyword);
    }

    private String getClockRankUrl(String wxGroupId, String wxUserId){
        String clockRankUrl = wechatGroupLinkPrefix
                .concat("/clock")
                .concat("?wxGroupId=").concat(wxGroupId)
                .concat("&wxUserId=").concat(wxUserId);
        return UrlUtils.getShortUrl4Own(clockRankUrl);
    }

    private String getClockRewardUrl(Long clockPrizeId){
        StringBuffer sbu=new StringBuffer();
        if(null != clockPrizeId  && !clockPrizeId.equals(0L)) {
            AppDto appDto = appConsr.getBaseById(clockPrizeId);
            AccountSettingDto accountSettingDto = qrcodeSceneConsr.getWechatInfo(appDto.getChannelId());
            if(null == accountSettingDto){
                return "";
            }
            String protocol = accountSettingDto.getProtocol();
            if (StringUtils.isEmpty(protocol)) {
                protocol = ChannelConstants.HTTP;
            }
            if(accountSettingDto.getRandom() != null) {
                sbu.append(protocol).append("app").append(accountSettingDto.getRandom()).append(".").append(accountSettingDto.getFirstDomain())
                        .append("/luck").append("/W").append(accountSettingDto.getAccountSettingId()).append("/C").append(appDto.getChannelId())
                        .append("/A").append(appDto.getAppId())
                        .append("/luckPage?isPreview=1&adviserId=").append(appDto.getCreatedUser()).append("&appType==").append(appDto.getTypeCode());
            }else{
                sbu.append(protocol).append("app.").append(accountSettingDto.getFirstDomain())
                        .append("/luck").append("/W").append(accountSettingDto.getAccountSettingId()).append("/C").append(appDto.getChannelId())
                        .append("/A").append(appDto.getAppId())
                        .append("/luckPage?isPreview=1&adviserId=").append(appDto.getCreatedUser()).append("&appType==").append(appDto.getTypeCode());
            }
            LOGGER.info("抽奖的跳转链接=====" + sbu.toString() + "================s");
            return UrlUtils.getShortUrl4Own(sbu.toString());
        }
        return "";
    }

    /**
     * 发送关键词信息
     * @param content
     * @param userWxId
     * @return
     */
    @Override
    @ParamLog("为微信群打卡关键词，发送关键词信息")
    @Transactional(rollbackFor = Exception.class)
    public Boolean sendKeywordMessage(String content, String userWxId,String wechatGroupId, String wxId, String ip) {
        GroupClassifyQrcodeDTO classifyQrcodeInfo = bookGroupClassifyBiz.getClassifyQrcodeInfo(wechatGroupId);
        if(null == classifyQrcodeInfo){
            return null;
        }
        WeixinClockDto weixinClockDto = weixinClockGroupClassifyDao.getClockBaseInfoByClassify(classifyQrcodeInfo.getClassifyId());
        WeixinClockMember clockMember = weixinClockMemberDao.getByWxUserId(wechatGroupId, userWxId);
        GroupUserDTO groupUserDTO = wechatGroupConsr.getWxUserInfoByWxUserId(userWxId);
        Long weixinClockMemberId = clockMember == null ? null : clockMember.getWeixinClockMemberId();
        if(null == clockMember) {
            WeixinClockMember weixinClockMember = new WeixinClockMember();
            weixinClockMember.setWeixinClockId(weixinClockDto.getWeixinClockId());
            weixinClockMember.setAllClockDay(1);
            weixinClockMember.setBookGroupClassifyId(classifyQrcodeInfo.getClassifyId());
            weixinClockMember.setHeadPic(groupUserDTO.getHeadPic());
            weixinClockMember.setNickname(groupUserDTO.getNickName());
            weixinClockMember.setWxGroupId(wechatGroupId);
            weixinClockMember.setWxUserId(userWxId);
            weixinClockMemberId = weixinClockMemberDao.insert(weixinClockMember);
        }
        SendTextMessageVO vo = new SendTextMessageVO();
        vo.setAltId(wxId);
        vo.setWxGroupId(wechatGroupId);
        vo.setIp(ip);
        String sendContent = "";
        String nickname = groupUserDTO.getNickName();
        if(StringUtil.isEmpty(nickname)){
            nickname = "神秘客";
        }
        WeixinClockTopic weixinTopic = weixinClockTopicDao.getTopicByIds4Today(wechatGroupId, userWxId);
        if(null == weixinTopic){
            WeixinClockTopic weixinClockTopic = new WeixinClockTopic();
            weixinClockTopic.setBookGroupClassifyId(classifyQrcodeInfo.getClassifyId());
            weixinClockTopic.setCreatedDay(new Date());
            weixinClockTopic.setWeixinClockId(weixinClockDto.getWeixinClockId());
            weixinClockTopic.setWxGroupId(wechatGroupId);
            weixinClockTopic.setWxUserId(userWxId);
            weixinClockTopic.setWeixinClockMemberId(weixinClockMemberId);
            weixinClockMemberDao.updateClockDays(wechatGroupId, userWxId);
            weixinClockTopicDao.insert(weixinClockTopic);
            //发topic，增加抽奖次数
            //发送抽奖的TOPIC
            Long clockDays = weixinClockTopicDao.getClockCountByUser(wechatGroupId, userWxId);
            PromotionOrderDto promotionOrderDto = new PromotionOrderDto();
            List<PromotionGiftDto> promotionGiftDtoList = new ArrayList<>();
            PromotionGiftDto promotionGiftDto = new PromotionGiftDto();
            promotionGiftDto.setTargetClass(PromotionOrderEnum.TARGET_CLASS_APP.getCode());
            promotionGiftDto.setTargetType(AppTypeEnum.DRAW.value);
            promotionGiftDto.setTargetId(weixinClockDto.getClockPrizeId());
            Integer grantNum = weixinClockRewardDao.getGrantNumFromReward(weixinClockDto.getWeixinClockId(), clockDays);
            promotionGiftDto.setGrantNum(grantNum == null ? "0" :grantNum.toString());
            promotionGiftDtoList.add(promotionGiftDto);
            promotionOrderDto.setGifts(promotionGiftDtoList);
            AppDto appDto = appConsr.getBaseById(weixinClockDto.getClockPrizeId());
            promotionOrderDto.setUserId(readerConsr.getWechatUserId(userWxId, appDto.getChannelId()));
            LOGGER.info("发送抽奖规则,参数：promotionOrderDto="+promotionOrderDto);
            amqpTemplate.convertAndSend(MQTopicProducer.EXCHAGE, MQTopicProducer.GIVE_GIFT, promotionOrderDto);
            //获取我的新排名
            Integer newOrder = weixinClockMemberDao.getMyNewOrder(wechatGroupId, userWxId);
            String clockRewardUrl = getClockRewardUrl(weixinClockDto.getClockPrizeId());
            String clockRankUrl = getClockRankUrl(wechatGroupId, userWxId);
            Calendar today = Calendar.getInstance();
            int month = today.get(Calendar.MONTH) + 1;
            int dayOfMonth = today.get(Calendar.DAY_OF_MONTH);
            sendContent = "@" + nickname + " "+ weixinClockDto.getClockIntroduction() + "\\n" + month + "月" + dayOfMonth + "日打卡成功，你已累积打卡"
                    + clockDays + "天，排名第" +
                    newOrder + "，明天继续！" + "\\n" + "\\n" + "查看排行榜：" + clockRankUrl + "点击抽奖，即可有机会获得精美礼品哦：" + clockRewardUrl;
        } else {
            sendContent = "@" + nickname + " ，你今天已经打过卡了，明天再继续！";
        }
        vo.setContent(sendContent);
        LOGGER.info("微信群内加入并打卡：发送微信消息vo="+vo);
        WxGroupSDK.sendTextMessage(vo);
        return true;
    }

    /**
     * 获取某个群内的打卡排行榜
     * @param wxGroupId
     * @param wxUserId
     * @return
     */
    @Override
    @ParamLog("获取某个群内的打卡排行榜")
    public List<RankDto> listWeixinClockRank(String wxGroupId, String wxUserId) {
        return weixinClockMemberDao.listWeixinClockRank(wxGroupId, wxUserId);
    }

}
