package com.pcloud.book.weixinclock.dao;

import com.pcloud.book.group.vo.StatisticVO;
import com.pcloud.book.weixinclock.dto.WeixinClockDto;
import com.pcloud.book.weixinclock.entity.WeixinClockGroupClassify;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * @author 杨涛
 * @description 群分类
 * @date 2019/8/15 11:25
 */
public interface WeixinClockGroupClassifyDao extends BaseDao<WeixinClockGroupClassify> {

    /**
     * 批量插入
     * @param groupClassifyIds
     */
    void batchInsert(List<WeixinClockGroupClassify> groupClassifyIds);

    /**
     * 获取该群分类下的打卡关键字
     * @param paramMap
     * @return
     */
    String getKeywordByGroupClassify (Map<String,Object> paramMap);

    /**
     * 根据群分类获取某个群的详细信息
     * @param bookGroupClassifyId
     * @return
     */
    WeixinClockDto getClockBaseInfoByClassify(Long bookGroupClassifyId);

    /**
     * 根据weixinClockId获取群分类等统计
     * @param weixinClockId
     * @return
     */
    StatisticVO getClockGroupStatistics(Long weixinClockId);

}
