package com.pcloud.book.weixinclock.dao.impl;

import com.pcloud.book.group.vo.StatisticVO;
import com.pcloud.book.weixinclock.dao.WeixinClockGroupClassifyDao;
import com.pcloud.book.weixinclock.dto.WeixinClockDto;
import com.pcloud.book.weixinclock.entity.WeixinClockGroupClassify;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @author 杨涛
 * @description TODO
 * @date 2019/8/15 11:25
 */
@Repository("weixinClockGroupClassifyDao")
public class WeixinClockGroupClassifyDaoImpl extends BaseDaoImpl<WeixinClockGroupClassify> implements WeixinClockGroupClassifyDao {

    /**
     * 批量插入
     * @param groupClassifyIds
     */
    @Override
    public void batchInsert(List<WeixinClockGroupClassify> groupClassifyIds) {
        super.sqlSessionTemplate.insert(getStatement("batchInsert"),groupClassifyIds);
    }

    /**
     * 获取该群分类下的打卡关键字
     * @param paramMap
     * @return
     */
    @Override
    public String getKeywordByGroupClassify(Map<String, Object> paramMap) {
        return super.sqlSessionTemplate.selectOne(getStatement("getKeywordByGroupClassify"),paramMap);
    }

    /**
     * 根据群分类获取某个群的详细信息
     * @param bookGroupClassifyId
     * @return
     */
    @Override
    public WeixinClockDto getClockBaseInfoByClassify(Long bookGroupClassifyId) {
        return super.sqlSessionTemplate.selectOne(getStatement("getClockBaseInfoByClassify"),bookGroupClassifyId);
    }

    /**
     * 获取打卡统计
     * @param weixinClockId
     * @return
     */
    @Override
    public StatisticVO getClockGroupStatistics(Long weixinClockId) {
        return this.getSqlSession().selectOne(this.getStatement("getClockGroupStatistics"), weixinClockId);
    }

}
