package com.pcloud.book.weixinclock.dao.impl;

import com.pcloud.book.weixinclock.dao.WeixinClockMemberDao;
import com.pcloud.book.weixinclock.dto.RankDto;
import com.pcloud.book.weixinclock.entity.WeixinClockMember;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author 杨涛
 * @description TODO
 * @date 2019/8/16 9:59
 */
@Repository("weixinClockMemberDao")
public class WeixinClockMemberDaoImpl extends BaseDaoImpl<WeixinClockMember> implements WeixinClockMemberDao {

    /**
     * 获取某个群内的打卡排行榜
     * @param wxGroupId
     * @return
     */
    @Override
    public List<RankDto> listWeixinClockRank(String wxGroupId, String wxUserId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("wxGroupId",wxGroupId);
        paramMap.put("wxUserId",wxUserId);
        return super.sqlSessionTemplate.selectList(getStatement("listWeixinClockRank"),paramMap);
    }

    /**
     * 获取某个群内某用户的信息
     * @param userWxId
     * @return
     */
    @Override
    public WeixinClockMember getByWxUserId(String wechatGroupId, String userWxId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("wechatGroupId",wechatGroupId);
        paramMap.put("userWxId",userWxId);
        return super.sqlSessionTemplate.selectOne(getStatement("getByWxUserId"),paramMap);
    }

    /**
     * 更新打卡天数
     * @param userWxId
     * @return
     */
    @Override
    public void updateClockDays(String wechatGroupId, String userWxId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("wechatGroupId",wechatGroupId);
        paramMap.put("userWxId",userWxId);
        super.getSqlSession().update(this.getStatement("updateClockDays"), paramMap);
    }

    /**
     * 获取群内最新排名
     * @param userWxId
     * @return
     */
    @Override
    public Integer getMyNewOrder(String wechatGroupId, String userWxId){
        Map<String, Object> map = new HashMap<>();
        map.put("wechatGroupId", wechatGroupId);
        map.put("userWxId", userWxId);
        return  super.getSqlSession().selectOne(getStatement("getMyNewOrder"), map);
    }
}
