package com.pcloud.book.weixinclock.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.group.vo.StatisticVO;
import com.pcloud.book.weixinclock.entity.WeixinClockReward;
import com.pcloud.common.dto.BaseDto;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModelProperty;

/**
 * @author 杨涛
 * @description dto
 * @date 2019/8/15 9:13
 */
public class WeixinClockDto extends BaseDto {

    private static final long serialVersionUID = 2919177537250026356L;

    @ApiModelProperty("weixinClockId")
    private Long weixinClockId;

    @ApiModelProperty("群统计信息")
    private StatisticVO statisticVO;

    @ApiModelProperty("抽奖应用信息")
    private DrawRewardDto drawRewardDto;

    @ApiModelProperty("打卡奖励集合")
    private List<WeixinClockReward> weixinClockRewards;

    @ApiModelProperty("群分类集合")
    private List<Long> groupClassifyIds;

    @ApiModelProperty("打卡关键词")
    private String clockKeyword;

    @ApiModelProperty("打卡引导语")
    private String clockGuide;

    @ApiModelProperty("打卡简介")
    private String clockIntroduction;

    @ApiModelProperty("打卡奖励ID")
    private Long clockPrizeId;

    @ApiModelProperty("打卡奖励URL")
    private String clockPrizeUrl;

    @ApiModelProperty("创建人")
    private Long createUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createDate;

    @ApiModelProperty("最近修改人")
    private Long lastModifiedUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("最近修改时间")
    private Date lastModifiedDate;

    public Long getWeixinClockId() {
        return weixinClockId;
    }

    public void setWeixinClockId(Long weixinClockId) {
        this.weixinClockId = weixinClockId;
    }

    public StatisticVO getStatisticVO() {
        return statisticVO;
    }

    public void setStatisticVO(StatisticVO statisticVO) {
        this.statisticVO = statisticVO;
    }

    public DrawRewardDto getDrawRewardDto() {
        return drawRewardDto;
    }

    public void setDrawRewardDto(DrawRewardDto drawRewardDto) {
        this.drawRewardDto = drawRewardDto;
    }

    public List<WeixinClockReward> getWeixinClockRewards() {
        return weixinClockRewards;
    }

    public void setWeixinClockRewards(List<WeixinClockReward> weixinClockRewards) {
        this.weixinClockRewards = weixinClockRewards;
    }

    public List<Long> getGroupClassifyIds() {
        return groupClassifyIds;
    }

    public void setGroupClassifyIds(List<Long> groupClassifyIds) {
        this.groupClassifyIds = groupClassifyIds;
    }

    public String getClockKeyword() {
        return clockKeyword;
    }

    public void setClockKeyword(String clockKeyword) {
        this.clockKeyword = clockKeyword;
    }

    public String getClockGuide() {
        return clockGuide;
    }

    public void setClockGuide(String clockGuide) {
        this.clockGuide = clockGuide;
    }

    public String getClockIntroduction() {
        return clockIntroduction;
    }

    public void setClockIntroduction(String clockIntroduction) {
        this.clockIntroduction = clockIntroduction;
    }

    public Long getClockPrizeId() {
        return clockPrizeId;
    }

    public void setClockPrizeId(Long clockPrizeId) {
        this.clockPrizeId = clockPrizeId;
    }

    public String getClockPrizeUrl() {
        return clockPrizeUrl;
    }

    public void setClockPrizeUrl(String clockPrizeUrl) {
        this.clockPrizeUrl = clockPrizeUrl;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Override
    public Long getLastModifiedUser() {
        return lastModifiedUser;
    }

    @Override
    public void setLastModifiedUser(Long lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    @Override
    public Date getLastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    @Override
    public String toString() {
        return "WeixinClockDto{" +
                "weixinClockId=" + weixinClockId +
                ", statisticVO=" + statisticVO +
                ", drawRewardDto=" + drawRewardDto +
                ", weixinClockRewards=" + weixinClockRewards +
                ", groupClassifyIds=" + groupClassifyIds +
                ", clockKeyword='" + clockKeyword + '\'' +
                ", clockGuide='" + clockGuide + '\'' +
                ", clockIntroduction='" + clockIntroduction + '\'' +
                ", clockPrizeId=" + clockPrizeId +
                ", clockPrizeUrl='" + clockPrizeUrl + '\'' +
                ", createUser=" + createUser +
                ", createDate=" + createDate +
                ", lastModifiedUser=" + lastModifiedUser +
                ", lastModifiedDate=" + lastModifiedDate +
                '}';
    }
}
