package com.pcloud.book.weixinclock.facade.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.group.vo.BookGroupClassifyVO;
import com.pcloud.book.group.vo.ListGroupClassifyParam;
import com.pcloud.book.weixinclock.biz.WeixinClockBiz;
import com.pcloud.book.weixinclock.dto.WeixinClockDto;
import com.pcloud.book.weixinclock.facade.WeixinClockFacade;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

import io.swagger.annotations.ApiParam;

/**
 * @author 杨涛
 * @description 接口实现层
 * @date 2019/8/14 19:15
 */
@RequestMapping("/weixinClock")
@RestController("weixinClockFacade")
public class WeixinClockFacadeImpl implements WeixinClockFacade {

    @Autowired
    private WeixinClockBiz weixinClockBiz;

    /**
     * 创建微信群签到打卡
     * @param token
     * @param weixinClockDto
     * @return
     * @throws BizException
     * @throws PermissionException
     */
    @Override
    @RequestMapping(value = "createWeixinClock", method = RequestMethod.POST)
    public ResponseDto<?> createWeixinClock(@RequestHeader("token") String token,
                                            @RequestBody WeixinClockDto weixinClockDto) throws BizException, PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        weixinClockDto.setCreateUser(adviserId);
        weixinClockDto.setLastModifiedUser(adviserId);
        return new ResponseDto<>(weixinClockBiz.createWeixinClock(weixinClockDto));
    }

    /**
     * 获取微信群签到打卡信息
     * @param token
     * @param weixinClockId
     * @return
     * @throws BizException
     * @throws PermissionException
     */
    @Override
    @RequestMapping(value = "getWeixinClockBaseInfo", method = RequestMethod.GET)
    public ResponseDto<?> getWeixinClockBaseInfo(@RequestHeader("token") String token,
                                                 @RequestParam(value = "weixinClockId",required = false) Long weixinClockId) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(weixinClockBiz.getWeixinClockBaseInfo(weixinClockId));
    }

    @Override
    @RequestMapping(value = "listGroupClassify4Clock", method = RequestMethod.POST)
    public ResponseDto<PageBeanNew<BookGroupClassifyVO>> listGroupClassify4Clock(@RequestHeader("token") String token,
                                                                                 @RequestBody ListGroupClassifyParam listGroupClassifyParam) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        PageBeanNew<BookGroupClassifyVO> pageBeanNew = weixinClockBiz.listGroupClassify4Clock(listGroupClassifyParam, adviserId);
        return new ResponseDto<>(pageBeanNew);
    }

    /**
     * 修改微信群签到打卡
     * @param token
     * @param weixinClockDto
     * @return
     * @throws BizException
     * @throws PermissionException
     */
    @Override
    @RequestMapping(value = "updateWeixinClock", method = RequestMethod.POST)
    public ResponseDto<?> updateWeixinClock(@RequestHeader("token") String token,
                                            @RequestBody WeixinClockDto weixinClockDto) throws BizException, PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if(null == weixinClockDto || null == weixinClockDto.getWeixinClockId()){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"参数有误");
        }
        weixinClockDto.setLastModifiedUser(adviserId);
        weixinClockBiz.updateWeixinClock(weixinClockDto);
        return new ResponseDto<>();
    }

    /**
     * 删除微信群签到打卡
     * @param token
     * @param weixinClockId
     * @return
     * @throws BizException
     * @throws PermissionException
     */
    @Override
    @RequestMapping(value = "deleteWeixinClock", method = RequestMethod.GET)
    public ResponseDto<?> deleteWeixinClock(@RequestHeader("token") String token,
                                            @RequestParam(value = "weixinClockId",required = false) Long weixinClockId) throws BizException, PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if(null == weixinClockId){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"参数有误！");
        }
        weixinClockBiz.deleteWeixinClock(weixinClockId,adviserId);
        return new ResponseDto<>();
    }

    /**
     * 微信群签到打卡列表(编辑端)
     * @param token
     * @param keyword
     * @return
     * @throws BizException
     * @throws PermissionException
     */
    @Override
    @RequestMapping(value = "listWeixinClock4Adviser", method = RequestMethod.GET)
    public ResponseDto<?> listWeixinClock4Adviser(@RequestHeader("token") String token,
                                                  @RequestParam(value = "keyword" ,required = false) String keyword,
                                                  @RequestParam(value = "currentPage", required = false) Integer currentPage,
                                                  @RequestParam(value = "numPerPage", required = false) Integer numPerPage) throws BizException, PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if(null == currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"分页参数有误");
        }
        PageParam pageParam = new PageParam(currentPage,numPerPage);
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("keyword", keyword != null && "".equals(keyword.trim()) ? null : keyword);
        paramMap.put("adviserId", adviserId);
        return new ResponseDto<>(weixinClockBiz.listWeixinClock4Adviser(pageParam, paramMap));
    }

    /**
     * 获取某个微信群签到打卡的所有群分类详情
     * @param token
     * @param weixinClockId
     * @return
     * @throws BizException
     * @throws PermissionException
     */
    @Override
    @RequestMapping(value = "listGroupClassifyDetail4Clock", method = RequestMethod.GET)
    public ResponseDto<?> listGroupClassifyDetail4Clock(@RequestHeader("token") String token,
                                                        @RequestParam("weixinClockId") Long weixinClockId,
                                                        @RequestParam(value = "currentPage", required = false) Integer currentPage,
                                                        @RequestParam(value = "numPerPage", required = false) Integer numPerPage) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        PageBeanNew<BookGroupClassifyVO> pageBeanNew = weixinClockBiz.listGroupClassifyDetail4Clock(weixinClockId, currentPage, numPerPage);
        return new ResponseDto<>(pageBeanNew);
    }

    /**
     * 获取某个群内的打卡排行榜
     * @param userInfo
     * @return
     * @throws BizException
     * @throws PermissionException
     */
    @Override
    @RequestMapping(value = "listWeixinClockRank", method = RequestMethod.GET)
    public ResponseDto<?> listWeixinClockRank(@CookieValue("userInfo")String userInfo,
                                              @RequestParam(value = "wxGroupId", required = false) String wxGroupId,
                                              @RequestParam(value = "wxUserId", required = false) String wxUserId)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(weixinClockBiz.listWeixinClockRank(wxGroupId, wxUserId));
    }

}
