package com.pcloud.book.group.biz;

import com.pcloud.book.group.dto.*;
import com.pcloud.book.group.entity.BookGroupClassify;
import com.pcloud.book.group.vo.*;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;

import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/16 21:02
 */
public interface BookGroupClassifyBiz {
    /**
     * @Author:lili
     * @Desr:新增分类
     * @Date:2019/4/17 15:53
     */
    void addClassify(AddClassifyVO addClassifyVO, Long partyId);

    /**
     * @Author:lili
     * @Desr:更新分类
     * @Date:2019/4/17 15:53
     */
    void updateClassify(UpdateClassifyVO updateClassifyVO, Long partyId);

    /**
     * @Author:lili
     * @Desr:获取分类列表
     * @Date:2019/4/17 15:53
     */
    List<ListClassifyVO> listAllClassify(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:删除群分类
     * @Date:2019/4/17 15:57
     */
    void deleteClassify(Long classifyId, Long partyId);

    /**
     * @Author:lili
     * @Desr:获取群分类
     * @Date:2019/4/18 9:53
     */
    ClassifyVO getClassify(Long classifyId);

    /**
     * @Author:lili
     * @Desr:根据规格对应分类信息
     * @Date:2019/4/19 11:46
     */
    ClassifyDTO getBaseInfoBySpecId(Long productSpecId);

    /**
     * @Author:lili
     * @Desr:修改排序值
     * @Date:2019/4/22 15:53
     */
    void updateClassifyRank(UpdateRankVO updateRankVO, Long partyId);
    
    /**
     * @Author:lili
     * @Desr:获取所有分类
     * @Date:2019/4/22 16:01
     */
    List<ClassifyNameVO> listClassify(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:获取分类与群数量
     * @Date:2019/4/25 18:03
     */
    ClassifyAndGroupCountVO getClassifyAndGroupCount(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:获取分类与群总人数
     * @Date:2019/4/26 14:34
     */
    ClassifyAndUserCountVO getClassifyAndUserCount(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:获取分类社群码名称以及最大群数量
     * @Date:2019/4/28 17:25
     */
    GroupNameAndMaxSeqDTO getGroupNameAndMaxSeq(Long classifyId);

    /**
     * @Author:lili
     * @Desr:获取分类二维码相关标识
     * @Date:2019/4/28 20:32
     */
    GroupClassifyQrcodeDTO getClassifyQrcodeInfo(String weixinGroupId);

    /**
     * @Author:lili
     * @Desr:客户端获取分类信息
     * @Date:2019/4/29 10:30
     */
    List<ListClassify4WechatVO> listClassify4Wechat(Long bookGroupId, Long wechatUserId);

    /**
     * @Author:lili
     * @Desr:客户端根据群分类获取二维码
     * @Date:2019/4/29 17:21
     */
    GroupQrcode4ClassifyVO getGroupQrcode4ClassifyWechat(Long classifyId, Long wechatUserId);

    /**
     * @Author:lili
     * @Desr:获取编辑所有的分类
     * @Date:2019/4/30 15:33
     */
    PageBeanNew<BookGroupClassifyVO> listGroupClassifyByAdviser(ListGroupClassifyParam listGroupClassifyParam, Long adviserId);

    /**
     * @Author:lili
     * @Desr:获取社群码统计数据（分类数，群总人数，群数量）
     * @Date:2019/4/30 17:38
     */
    Map<Long , BookGroupStatisticDTO> getBookGroupStatistic(List<Long> bookGroupIds);

    /**
     * @Author:lili
     * @Desr:获取单个群统计
     * @Date:2019/5/6 16:17
     */
    PageBeanNew<BookGroupQrcodeStatisticVO> listBookGroupQrcodeStatistic(ListBookGroupQrcodeParamVO listBookGroupQrcodeParamVO, Long adviserId);

    /**
     * @Author:lili
     * @Desr:单个群统计导出
     * @Date:2019/5/6 17:26
     */
    void bookGroupQrcodeStatisticExport(List<Long> classifyIds, Long bookGroupId, Long adviserId);

    /**
     * @Author:lili
     * @Desr: 获取编辑的社群码统计数据
     * @Date:2019/5/9 11:23
     */
    StatisticVO getStatistic4Adviser(Long adviserId);

    /**
     * @Author:lili
     * @Desr: 获取群二维码基本信息
     * @Date:2019/5/10 14:50
     */
    Map<String,GroupQrcodeBaseDTO> listGroupQrcodeBaseInfo(List<String> weixinGroupIds);

    /**
     * @Author:lili
     * @Desr:获取商品关联群数量与人数
     * @Date:2019/5/10 20:18
     */
    ProAssocGroupAndUserNumberDTO getProAssocGroupAndUserNumber(Long productId);

    /**
     * @Author:hzk
     * @Desr:获取分类列表
     * @Date:2019/4/17 15:53
     */
    PageBeanNew<ClassifyDTO> listSimpleBookGroupClassify4Adviser(Long adviserId, BookGroupClassify bookGroupClassify, PageParam pageParam);

    PageBeanNew<AdviserClassifyVO> listAdviserClassify(Long adviserId, AdviserClassifyParam adviserClassifyParam);
    /**
     * 更新是否开启微学习报告
     */
    void updateHasOpenLearningReport(Long classifyId, Boolean hasOpenLearningReport, Long partyId);

    /**
     * 获取群分类学习报告相关列表
     */
    PageBeanNew<ClassifyLearningReportDto> listClassifyForLearningReport(Integer currentPage, Integer numPerPage, String keyword, Long partyId);

}
