package com.pcloud.book.applet.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;
import com.pcloud.common.entity.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

import lombok.Data;

/**
 * 书单推荐书籍(AppletOuterBook)实体类
 *
 * @author makejava
 * @since 2020-08-11 11:51:24
 */
@Data
public class AppletOuterBookDTO extends BaseDto {
    private static final long serialVersionUID = 283162706407945358L;

    private Long id;
    private Long configId;
    /**
    * 封面
    */
    private String coverImg;
    /**
    * 书籍名称
    */
    private String bookName;
    /**
    * 出版社
    */
    private String publish;
    /**
    * 作者
    */
    private String author;
    /**
    * isbn
    */
    private String isbn;
    /**
    * 简介
    */
    private String remark;
    /**
     * 价格
     */
    private BigDecimal price;
    /**
    * 链接来源1当当2京东3拼多多
    */
    private Integer linkType;
    /**
    * 跳转链接
    */
    private String linkUrl;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;


}