package com.pcloud.book.adnews.service.impl;

import com.pcloud.book.adnews.biz.AdNewsBiz;
import com.pcloud.book.adnews.service.AdNewsService;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/7/18 14:45
 **/
@RestController("adNewsService")
@RequestMapping("adNewsService")
public class AdNewsServiceImpl implements AdNewsService {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdNewsServiceImpl.class);

    private static final ExecutorService EXECUTOR_SINGLE_SERVICE = Executors.newSingleThreadExecutor();

    @Autowired
    private AdNewsBiz adNewsBiz;

    @ApiOperation("发送编辑端早晚报")
    @PostMapping("/sendAdNews")
    @Override
    public void sendAdNews(@RequestBody Map<String, Object> map) throws BizException {
        LOGGER.info("内部接口发送编辑端早晚报被调用" + map.toString());
        //开线程跑，及时给定时任务返回，避免超时重复调用
        EXECUTOR_SINGLE_SERVICE.execute(() -> adNewsBiz.sendAdNews(new Long(map.get("adNewsSetId").toString())));
    }

}
